package com.example.sefinsa_app.ui.clientes.fotos;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.ClipData;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CameraMetadata;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.location.Location;
import android.location.LocationManager;
import android.media.Image;
import android.media.ImageReader;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.provider.Settings;
import android.util.Log;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.example.sefinsa_app.ColaSolicitudes;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.SolicitudSubida;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.DeviceUtils;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.RealPathUtil;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputEditText;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Struct;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ClientesAvalesFotosFragment extends Fragment {

    private ClientesAvalesFotosViewModel mViewModel;

    private final int CODIGO_PERMISOS_CAMARA = 1;
    private static final int CODIGO_SELECCION_MULTIPLE = 2;

    private Button btnImagenesGarantias, btnImagenesComprobantes, btnImagenesIne, btnImagenesContrato, btnImagenesFachada, btnImagenesFoto,
            btnGuardarFotos, btnUbicacion, btnCamGarantiasRetiradas, btnGuardarGarantiasRetiradas, btnImagenesGarantiasAval, btnImagenesComprobantesAval,
            btnImagenesIneAval, btnImagenesFotoAval, btnImagenesFachadaAval, btnUbicacionCliente, btnUbicacionAval;

    private boolean camaraGarantiasClienteAbierta = false;
    private boolean camaraComprobantesClienteAbierta = false;
    private boolean camaraGarantiasRetiradas = false;

    private boolean camaraIneClienteAbierta = false;
    private boolean camaraContratoClienteAbierta = false;
    private boolean camaraFotoAbierta = false;
    private boolean camaraFachadaAbierta = false;
    private int fileIndex = 3;

    //BOTONES DE CAMARA PARA AVAL
    private boolean camaraIneAvalAbierta = false;
    private boolean camaraGarantiasAvalAbierta = false;
    private boolean camaraComprobantesAvalAbierta = false;
    private boolean camaraFotoAvalAbierta = false;
    private boolean camaraFachadaAvalAbierta = false;
    private int fileIndexAval = 3;

    private SharedPreferences sesion;

    private ImageView tachaIneFrente, tachaIneReverso, tachaComprobante, tachaGarantia1, tachaGarantia2, tachaGarantia3, tachaGarantia4, tachaFoto, tachaContratoFrente, tachaContratoReverso, tachaFechada,
            imgIneFrente, imgIneReverso, imgComprobante, imgGarantia1, imgGarantia2, imgGarantia3, imgGarantia4, imgFoto, imgFachada, imgContratoFrente, imgContratoReverso, ImageView2,
    tachaIneFrenteA, tachaIneReversoA, tachaComprobanteA, tachaGarantia1A, tachaGarantia2A, tachaGarantia3A, tachaGarantia4A, tachaFotoA, tachaFachadaA,
    imgIneFrenteA, imgIneReversoA, imgComprobanteA, imgGarantia1A, imgGarantia2A, imgGarantia3A, imgGarantia4A, imgFotoA, imgFachadaA;

    List<MultipartBody.Part> archivosGeneral;

    ///// PATHS CLIENTES
    private ArrayList<String> pathsGarantiasCliente;
    private ArrayList<String> pathsComprobantesCliente;
    private ArrayList<String> pathsIneCliente;
    private ArrayList<String> pathsFotoCliente;
    private ArrayList<String> pathsContratoCliente;
    private ArrayList<String> pathsFachadaCliente;
    private ArrayList<String> pathsGarantiasRetiradas;

    private ArrayList<String> pathsGarantiasCliente2;
    private ArrayList<String> pathsComprobantesCliente2;
    private ArrayList<String> pathsIneCliente2;
    private ArrayList<String> pathsFotoCliente2;
    private ArrayList<String> pathsContratoCliente2;
    private ArrayList<String> pathsFachadaCliente2;

    ///// PATHS AVALES
    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;
    private ArrayList<String> pathsIneAval;
    private ArrayList<String> pathsFotoAval;
    private ArrayList<String> pathsFachadaAval;

    private ArrayList<String> pathsGarantiasAval2;
    private ArrayList<String> pathsComprobantesAval2;
    private ArrayList<String> pathsIneAval2;
    private ArrayList<String> pathsFotoAval2;
    private ArrayList<String> pathsFachadaAval2;

    private Aval aval;
    private String avalId;

    private Cliente cliente;
    private String clienteId;

    int clienteprestamo;

    private Surface surface;
    private SurfaceHolder surfaceHolder;
    private boolean surfaceReady = false;

    String aval_nombre;
    String cliente_nombre;

    private int banderaGarantiasClientes, banderaComprobantesClientes, banderaGarantiasAvales, banderaComprobantesAvales, banderaGarantiasRetiradas, banderaFotoAvales;

    String path;
    String pathAval;

    private Uri image_uri, selectedImageUri,uri, image_uriAval, selectedImageUriAval,uriAval;

    private TextView tvCliente, tvAval;
    private TextInputEditText etDescGarantia;
    String lat = "";
    String lgt = "";
    String latAval = "";
    String lgtAval = "";
    private VolleyS vs;
    private RequestQueue requestQueue;
    FusedLocationProviderClient client;

    private static final int CAMERA_PERMISSION_REQUEST_CODE = 100;
    private CameraDevice cameraDevice;

    public static ClientesAvalesFotosFragment newInstance() {
        return new ClientesAvalesFotosFragment();
    }
    private OnPhotosSelectedListener listener;
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_clientes_avales_fotos, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        client = LocationServices
                .getFusedLocationProviderClient(
                        getActivity());
        initElements(view);

        Bundle args = getArguments();
        String personJsonString = args != null ? args.getString("cliente") : null;

        if (personJsonString != null && !personJsonString.isEmpty()) {
            // Si el JSON no es null ni vacío, lo parseamos como un aval existente
            cliente = Utils.getGsonParser().fromJson(personJsonString, Cliente.class);
            Log.d("DEBUG2", "DATO DE PARSE EN ClientesAvalesFOTOSFRAGMENT: " + personJsonString);
            CurrentFragment.fragment = "ClientesAvalesFotosFragment";

            clienteId = cliente.getId();
            avalId = cliente.getAval_id();
            aval_nombre = args != null ? args.getString("avalNombre", "Nuevo") : "Nuevo";
            Log.d("DEBUG2", "DATO DE PARSE EN avalId: " + avalId);
            tvCliente.setText("CLIENTE: \n" + cliente.getNombre_completo());
            tvAval.setText("AVAL: \n" +aval_nombre);

            aval = Utils.getGsonParser().fromJson(personJsonString, Aval.class);


            // Llamamos a getFiles sin pasar contenedor
            getFiles("comprobantes/clientes/" + cliente.getId() + "_" + cliente.getNombre_completo().toUpperCase());
            getFiles("garantias/clientes/" + cliente.getId() + "_" + cliente.getNombre_completo().toUpperCase());
            getFilesA("comprobantes/avales/" + cliente.getAval_id() + "_" + aval_nombre.toUpperCase());
            getFilesA("garantias/avales/" + cliente.getAval_id() + "_" + aval_nombre.toUpperCase());
        } else {
            // Si no hay un JSON, entonces obtenemos el nombre del nuevo aval
            cliente_nombre = args != null ? args.getString("clienteNombre", "Nuevo") : "Nuevo";
            tvCliente.setText("CLIENTE: \n" +cliente_nombre);

            cliente = null; // Aquí no se necesita crear un objeto vacío, simplemente lo dejamos en null.
            Log.d("DEBUG2", "No se encontró un cliente existente, es un nuevo cliente.");
            Log.d("DEBUG2", "Nombre del nuevo cliente: " + cliente_nombre);
        }
    }
    public void getFiles(String carpeta) {
        Log.d("DEBUG2", "getFiles() llamado con carpeta: " + carpeta);
        pathsComprobantesCliente.clear();
        pathsGarantiasCliente.clear();

        pathsIneCliente.clear();
        pathsContratoCliente.clear();
        pathsFachadaCliente.clear();
        pathsFotoCliente.clear();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        String path = API.url.replace("php/", "resources/");
        //String path = "https://sw.gruposefinsa.com/resources/";
        //String path = "https://gruposefinsa.com/test/resources/";
        String ruta = "../../resources/" + carpeta;
        Log.d("ruta", ruta);

        JSONObject data = new JSONObject();
        try {
            data.put("func", "archivos");
            data.put("ruta", ruta);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        Log.d("5", "loadAllData: ");

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            Log.d("data", String.valueOf(data));

                            if (!response.get("data").toString().equals("false")) {
                                JSONArray jsonArray = (JSONArray) response.get("data");
                                Log.d("archivos", jsonArray.length() + "");

                                // Crear una lista para almacenar los nombres de archivo
                                //pathsGarantiasCliente.clear(); // Limpiar la lista antes de agregar nuevos archivos
                                List<String> fileNames = new ArrayList<>();

                                // Procesamos la lista de nombres de archivo
                                for (int i = 0; i < jsonArray.length(); i++) {
                                    String fileName = jsonArray.getString(i);
                                    if (fileName.equals(".") || fileName.equals("..")) {
                                        continue; // Ignora estos nombres
                                    }

                                    if (fileName.endsWith("GC.jpeg")) {
                                        // Agregar a la lista de archivos y la lista pathsGarantiasAval solo si cumple con la condición
                                        pathsGarantiasCliente.add(fileName); // Agregar a la lista global solo si es GC
                                    }
                                    if (fileName.equals("0CC.jpeg") || fileName.equals("1CC.jpeg")) {
                                        pathsIneCliente.add(fileName);
                                    }
                                    if (fileName.equals("3CC.jpeg") || fileName.equals("4CC.jpeg")) {
                                        pathsContratoCliente.add(fileName);
                                    }
                                    // Agregar a la lista de archivos
                                    fileNames.add(fileName);
                                }

                                // Después de procesar los archivos, buscamos los índices faltantes
                                List<Integer> missingIndices = null;
                                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
                                    missingIndices = findMissingIndices(pathsGarantiasCliente);
                                }

                                // Logging de los índices faltantes
                                if (missingIndices.isEmpty()) {
                                    Log.d("findMissingIndices", "No faltan índices.");
                                } else {
                                    Log.d("findMissingIndices", "Índices faltantes getFiles(): " + missingIndices);
                                }

                                // Lista nueva para almacenar los nombres de archivo con "T" al final
                                List<String> modifiedFileNames = new ArrayList<>();

                                // Iteramos sobre los nombres de archivo
                                for (String fileName : fileNames) {
                                    if (fileName.equals(".") || fileName.equals("..")) {
                                        continue; // Ignora estos nombres
                                    }
                                    Log.d("FILE", fileName);

                                    // Verificar la longitud de fileName antes de intentar acceder a sus índices
                                    if (fileName.length() <= 3) {
                                        Log.e("ERROR", "Nombre de archivo demasiado corto: " + fileName);
                                        continue; // Saltar a la siguiente iteración si el nombre de archivo es demasiado corto
                                    }

                                    // Si el archivo termina con "CC.jpeg" o "GC.jpeg" y no tiene "T" al final, agregarle "T" antes de la extensión
                                    if ((fileName.endsWith("CC.jpeg") || fileName.endsWith("GC.jpeg")) && !fileName.contains("T")) {
                                        // Agregar "T" antes de ".jpeg"
                                        String modifiedFileName = fileName.substring(0, fileName.length() - 5) + "T" + fileName.substring(fileName.length() - 5);
                                        modifiedFileNames.add(modifiedFileName);
                                        Log.d("MODIFIED", "Archivo modificado: " + modifiedFileName);
                                    } else {
                                        // Si ya tiene "T" al final o no termina en "CC" o "GC", agregamos el nombre tal cual
                                        modifiedFileNames.add(fileName);
                                    }
                                }

// Ahora procesamos los archivos con la "T" añadida o los archivos originales
                                for (String fileName : modifiedFileNames) {
                                    Log.d("FILE", fileName);

                                    // Construimos la URL para cada archivo dentro de la subcarpeta 'Thumbnail'
                                    String imageUrl = path + carpeta + "/9Thumbnail/" + fileName;
                                    Log.d("imageUrl", "URL de la imagen TUMBNAIL: " + imageUrl);

                                    // Ahora que tenemos la URL, procedemos a analizar el prefijo y el sufijo
                                    String prefix = fileName.substring(0, 1); // Primer dígito (0, 1, 2...)
                                    String suffix = fileName.substring(1, 4); // Sufijo (IN, CA, GA, FO, FA)

                                    // Lógica para cargar las imágenes en el ImageView correspondiente
                                    ImageView imageView = null;
                                    // Determinamos cuál ImageView usar
                                    switch (suffix) {
                                        case "CCT": // INE
                                            if (prefix.equals("0")) {
                                                if (imgIneFrente.getDrawable() == null) { // Verificamos si está libre
                                                    imageView = imgIneFrente; // INE Frente
                                                }
                                            } else if (prefix.equals("1")) {
                                                if (imgIneReverso.getDrawable() == null) { // Verificamos si está libre
                                                    imageView = imgIneReverso; // INE Reverso
                                                }
                                            } else if (prefix.equals("2")) {
                                                if (imgComprobante.getDrawable() == null) { // Verificamos si está libre
                                                    imageView = imgComprobante; // COMPROBANTE
                                                }
                                            } else if (prefix.equals("3")) {
                                                if (imgContratoFrente.getDrawable() == null) { // Verificamos si está libre
                                                    imageView = imgContratoFrente; // FOTO AVAL
                                                }
                                            } else if (prefix.equals("4")) {
                                                if (imgContratoReverso.getDrawable() == null) { // Verificamos si está libre
                                                    imageView = imgContratoReverso; // FOTO CONTRATO REVERSO
                                                }
                                            } else if (prefix.equals("5")) {
                                                if (imgFoto.getDrawable() == null) { // Verificamos si está libre
                                                    imageView = imgFoto; // FOTO
                                                }
                                            } else if (prefix.equals("6")) {
                                                if (imgFachada.getDrawable() == null) { // Verificamos si está libre
                                                    imageView = imgFachada; // FACHADA DE LA CASA
                                                }
                                            }
                                            break;

                                        case "GCT": // Garantías
                                            if (prefix.equals("0")) {
                                                if (imgGarantia1.getDrawable() == null) { // Verificamos si está libre
                                                    imageView = imgGarantia1; // Garantía 1
                                                }
                                            } else if (prefix.equals("1")) {
                                                if (imgGarantia2.getDrawable() == null) { // Verificamos si está libre
                                                    imageView = imgGarantia2; // Garantía 2
                                                }
                                            } else if (prefix.equals("2")) {
                                                if (imgGarantia3.getDrawable() == null) { // Verificamos si está libre
                                                    imageView = imgGarantia3; // Garantía 3
                                                }
                                            } else if (prefix.equals("3")) {
                                                if (imgGarantia4.getDrawable() == null) { // Verificamos si está libre
                                                    imageView = imgGarantia4; // Garantía 4
                                                }
                                            }
                                            break;

                                        default:
                                            Log.e("ERROR", "Sufijo no reconocido: " + suffix);
                                    }

                                    // Cargar la imagen si se encontró el ImageView
                                    if (imageView != null) {
                                        imageView.setVisibility(View.VISIBLE);
                                        //Log.e("ERROR", "imageUrl para el Glide.......: " + imageUrl);

                                        // Cargar la imagen en el ImageView usando Glide
                                        Glide.with(getActivity())
                                                .load(imageUrl)  // La URL incluye un parámetro adicional para evitar caché
                                                .placeholder(R.drawable.ic_sincronizar) // Imagen de marcador de posición
                                                .fallback(R.drawable.ic_checkg)    // Imagen en caso de URL nula
                                                .diskCacheStrategy(DiskCacheStrategy.NONE)  // Desactiva la caché de disco
                                                .skipMemoryCache(true)
                                                .into(imageView);
                                    } else {
                                        Log.e("ERROR", "No se encontró un ImageView para el archivo: " + fileName);
                                    }
                                }

                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                Context context = getActivity(); // Obtén el contexto

                if (context != null) {
                    ErrorChecker.checker(error, context); // Llama al checker solo si el contexto no es nulo
                } else {
                    Log.e("onErrorResponse", "El contexto es nulo. No se pudo mostrar el error.");
                }
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                4000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    // Método findMissingIndices
    @RequiresApi(api = Build.VERSION_CODES.N)
    private List<Integer> findMissingIndices(List<String> pathsGarantiasCliente) {
        List<Integer> indices = new ArrayList<>();

        // Extraer los números de los archivos que terminan con GC.jpeg
        for (String fileName : pathsGarantiasCliente) {
            String indexString = fileName.replace("GC.jpeg", ""); // Remover el sufijo para obtener el índice
            try {
                int index = Integer.parseInt(indexString);
                indices.add(index);
            } catch (NumberFormatException e) {
                Log.e("findMissingIndices", "Error al obtener índice de archivo: " + fileName);
            }
        }

        // Ahora que tenemos los índices presentes, buscamos los faltantes
        List<Integer> missingIndices = new ArrayList<>();
        int maxIndex = indices.stream().max(Integer::compare).orElse(0);

        // Buscar los índices faltantes
        for (int i = 0; i <= maxIndex; i++) {
            if (!indices.contains(i)) {
                missingIndices.add(i);
            }
        }

        return missingIndices;
    }

    public void getFilesA(String carpeta) {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        pathsComprobantesAval.clear();
        pathsGarantiasAval.clear();
        pathsIneAval.clear();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        String path = API.url.replace("php/", "resources/");
        //String path = "https://sw.gruposefinsa.com/resources/";
        //String path = "https://gruposefinsa.com/test/resources/";
        String ruta = "../../resources/" + carpeta;
        Log.d("ruta", ruta);

        JSONObject data = new JSONObject();
        try {
            data.put("func", "archivos");
            data.put("ruta", ruta);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlAvales, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            dialog.cancel();
                            Log.d("data", String.valueOf(data));

                            if (!response.get("data").toString().equals("false")) {
                                JSONArray jsonArray = (JSONArray) response.get("data");
                                Log.d("archivos", jsonArray.length() + "");

                                // Crear una lista para almacenar los nombres de archivo
                                pathsGarantiasAval.clear(); // Limpiar la lista antes de agregar nuevos archivos
                                List<String> fileNames = new ArrayList<>();

                                // Procesamos la lista de nombres de archivo
                                for (int i = 0; i < jsonArray.length(); i++) {
                                    String fileName = jsonArray.getString(i);
                                    if (fileName.equals(".") || fileName.equals("..")) {
                                        continue; // Ignora estos nombres
                                    }
                                    Log.d("ARCHIVO RECIBIDO", "ARCHIVO RECIBIDO fileName: " + fileName);
                                    if (fileName.endsWith("GA.jpeg")) {
                                        // Agregar a la lista de archivos y la lista pathsGarantiasAval solo si cumple con la condición
                                        pathsGarantiasAval.add(fileName); // Agregar a la lista global solo si es GA
                                    }
                                    else
                                    {
                                        pathsGarantiasAval.clear();
                                    }
                                    if (fileName.equals("0CA.jpeg") || fileName.equals("1CA.jpeg")) {
                                        pathsIneAval.add(fileName);
                                    }
                                    else
                                    {
                                        pathsIneAval.clear();
                                    }
                                    // Agregar a la lista de archivos
                                    fileNames.add(fileName);
                                }

                                // Después de procesar los archivos, buscamos los índices faltantes
                                List<Integer> missingIndicesA = null;
                                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
                                    missingIndicesA = findMissingIndicesA(pathsGarantiasAval);
                                }

                                // Logging de los índices faltantes
                                if (missingIndicesA.isEmpty()) {
                                    Log.d("findMissingIndices", "No faltan índices.");
                                } else {
                                    Log.d("findMissingIndices", "Índices faltantes: " + missingIndicesA);
                                }

                                List<String> modifiedFileNames = new ArrayList<>();

                                // Iteramos sobre los nombres de archivo
                                for (String fileName : fileNames) {
                                    if (fileName.equals(".") || fileName.equals("..")) {
                                        continue; // Ignora estos nombres
                                    }
                                    Log.d("FILE", fileName);

                                    // Verificar la longitud de fileName antes de intentar acceder a sus índices
                                    if (fileName.length() <= 3) {
                                        Log.e("ERROR", "Nombre de archivo demasiado corto: " + fileName);
                                        continue; // Saltar a la siguiente iteración si el nombre de archivo es demasiado corto
                                    }

                                    // Si el archivo termina con "CC.jpeg" o "GC.jpeg" y no tiene "T" al final, agregarle "T" antes de la extensión
                                    if ((fileName.endsWith("CA.jpeg") || fileName.endsWith("GA.jpeg")) && !fileName.contains("T")) {
                                        // Agregar "T" antes de ".jpeg"
                                        String modifiedFileName = fileName.substring(0, fileName.length() - 5) + "T" + fileName.substring(fileName.length() - 5);
                                        modifiedFileNames.add(modifiedFileName);
                                        Log.d("MODIFIED", "Archivo modificado: " + modifiedFileName);
                                    } else {
                                        // Si ya tiene "T" al final o no termina en "CC" o "GC", agregamos el nombre tal cual
                                        modifiedFileNames.add(fileName);
                                    }
                                }

                                for (String fileName : modifiedFileNames) {
                                    Log.d("FILE", fileName);

                                    // Construimos la URL para cada archivo dentro de la subcarpeta 'Thumbnail'
                                    String imageUrl = path + carpeta + "/9Thumbnail/" + fileName;
                                    Log.d("imageUrl", "URL de la imagen TUMBNAIL: " + imageUrl);

                                    // Obtener el primer dígito y el sufijo
                                    String prefix = fileName.substring(0, 1); // Primer dígito (0, 1, 2...)
                                    String suffix = fileName.substring(1, 4); // Sufijo (IN, CA, GA, FO, FA)

                                    // Lógica para cargar las imágenes en el ImageView correspondiente
                                    ImageView imageView = null;

                                    // Determinamos cuál ImageView usar
                                    switch (suffix) {
                                        case "CAT": // INE
                                            if (prefix.equals("0") && imgIneFrenteA.getDrawable() == null) {
                                                imageView = imgIneFrenteA; // INE Frente
                                            } else if (prefix.equals("1") && imgIneReversoA.getDrawable() == null) {
                                                imageView = imgIneReversoA; // INE Reverso
                                            } else if (prefix.equals("2") && imgComprobanteA.getDrawable() == null) {
                                                imageView = imgComprobanteA; // COMPROBANTE
                                            } else if (prefix.equals("3") && imgFotoA.getDrawable() == null) {
                                                imageView = imgFotoA; // FOTO AVAL
                                            } else if (prefix.equals("4") && imgFachadaA.getDrawable() == null) {
                                                imageView = imgFachadaA; // FACHADA DE LA CASA
                                            }
                                            break;

                                        case "GAT": // Garantías
                                            Log.d("imageUrl", "VALOR DEL prefix: " + prefix);
                                            Log.d("imageUrl", "VALOR DEL suffix: " + suffix);
                                            if (prefix.equals("0") && imgGarantia1A.getDrawable() == null) {
                                                imageView = imgGarantia1A; // Garantía 1
                                            } else if (prefix.equals("1") && imgGarantia2A.getDrawable() == null) {
                                                imageView = imgGarantia2A; // Garantía 2
                                            } else if (prefix.equals("2") && imgGarantia3A.getDrawable() == null) {
                                                imageView = imgGarantia3A; // Garantía 3
                                            } else if (prefix.equals("3") && imgGarantia4A.getDrawable() == null) {
                                                imageView = imgGarantia4A; // Garantía 4
                                            }
                                            break;

                                        default:
                                            Log.e("ERROR", "Sufijo no reconocido: " + suffix);
                                    }

                                    // Cargar la imagen si se encontró el ImageView
                                    if (imageView != null) {
                                        imageView.setVisibility(View.VISIBLE);
                                        // Cargar la imagen en el ImageView usando Glide
                                        Glide.with(getActivity())
                                                .load(imageUrl)
                                                .placeholder(R.drawable.ic_sincronizar) // Imagen de marcador de posición
                                                .fallback(R.drawable.ic_checkg)    // Imagen en caso de URL nula
                                                .diskCacheStrategy(DiskCacheStrategy.NONE)  // Desactiva la caché de disco
                                                .skipMemoryCache(true)
                                                .into(imageView);
                                    } else {
                                        Log.e("ERROR", "No se encontró un ImageView para el archivo: " + fileName);
                                    }
                                }
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, getActivity());
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                4000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    // Método findMissingIndices
    @RequiresApi(api = Build.VERSION_CODES.N)
    private List<Integer> findMissingIndicesA(List<String> pathsGarantiasAval) {
        List<Integer> indices = new ArrayList<>();

        // Extraer los números de los archivos que terminan con GA.jpeg
        for (String fileName : pathsGarantiasAval) {
            String indexString = fileName.replace("GA.jpeg", ""); // Remover el sufijo para obtener el índice
            try {
                int index = Integer.parseInt(indexString);
                indices.add(index);
            } catch (NumberFormatException e) {
                Log.e("findMissingIndices", "Error al obtener índice de archivo: " + fileName);
            }
        }

        // Ahora que tenemos los índices presentes, buscamos los faltantes
        List<Integer> missingIndices = new ArrayList<>();
        int maxIndex = indices.stream().max(Integer::compare).orElse(0);

        // Buscar los índices faltantes
        for (int i = 0; i <= maxIndex; i++) {
            if (!indices.contains(i)) {
                missingIndices.add(i);
            }
        }

        return missingIndices;
    }

    EditText dateEdt;
    final Calendar myCalendar= Calendar.getInstance();
    private void updateLabel(){
        String myFormat = "yyyy-MM-dd";
        SimpleDateFormat dateFormat=new SimpleDateFormat(myFormat, Locale.US);
        dateEdt.setText(dateFormat.format(myCalendar.getTime()));
    }


    private void initElements(View view) {

        CurrentFragment.fragment = "ClientesAvalesFotosFragment";

        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        dateEdt = view.findViewById(R.id.etPlannedDate);

        DatePickerDialog.OnDateSetListener date = (view17, year, month, day) -> {
            myCalendar.set(Calendar.YEAR, year);
            myCalendar.set(Calendar.MONTH, month);
            myCalendar.set(Calendar.DAY_OF_MONTH, day);
            updateLabel();
        };

        dateEdt.setOnClickListener(view1 -> {
            new DatePickerDialog(this.getContext(), date, myCalendar.get(Calendar.YEAR), myCalendar.get(Calendar.MONTH), myCalendar.get(Calendar.DAY_OF_MONTH)).show();
        });

        tvCliente = view.findViewById(R.id.tvCliente);
        tvAval = view.findViewById(R.id.tvAval);
        etDescGarantia = view.findViewById(R.id.etDescGarantia);
        //tvCliente.setText("Cliente " + cliente.getNombre_completo());

        // Inicializar las listas CLIENTE
        pathsGarantiasCliente = new ArrayList<>();
        pathsComprobantesCliente = new ArrayList<>();
        pathsIneCliente = new ArrayList<>();
        pathsFotoCliente = new ArrayList<>();
        pathsContratoCliente = new ArrayList<>();
        pathsFachadaCliente = new ArrayList<>();

        pathsGarantiasCliente2 = new ArrayList<>();
        pathsComprobantesCliente2 = new ArrayList<>();
        pathsIneCliente2 = new ArrayList<>();
        pathsFotoCliente2 = new ArrayList<>();
        pathsContratoCliente2 = new ArrayList<>();
        pathsFachadaCliente2 = new ArrayList<>();

        pathsGarantiasRetiradas = new ArrayList<>();

        imgIneFrente = view.findViewById(R.id.imagenIneFrente);
        imgIneReverso = view.findViewById(R.id.imagenIneReverso);
        tachaIneFrente = view.findViewById(R.id.tachaIneFrente);
        tachaIneReverso = view.findViewById(R.id.tachaIneReverso);

        imgComprobante = view.findViewById(R.id.imagenComprobante);
        tachaComprobante = view.findViewById(R.id.tachaComprobante);

        imgGarantia1 = view.findViewById(R.id.imagenGarantia1);
        imgGarantia2 = view.findViewById(R.id.imagenGarantia2);
        imgGarantia3 = view.findViewById(R.id.imagenGarantia3);
        imgGarantia4 = view.findViewById(R.id.imagenGarantia4);
        tachaGarantia1 = view.findViewById(R.id.tachaGarantia1);
        tachaGarantia2 = view.findViewById(R.id.tachaGarantia2);
        tachaGarantia3 = view.findViewById(R.id.tachaGarantia3);
        tachaGarantia4 = view.findViewById(R.id.tachaGarantia4);

        imgFoto = view.findViewById(R.id.imagenFoto);
        tachaFoto = view.findViewById(R.id.tachaFoto);

        imgFachada = view.findViewById(R.id.imagenFachada);
        tachaFechada = view.findViewById(R.id.tachaFachada);

        imgContratoFrente = view.findViewById(R.id.imagenContratoFrente);
        tachaContratoFrente = view.findViewById(R.id.tachaContratoFrente);

        imgContratoReverso = view.findViewById(R.id.imagenContratoReverso);
        tachaContratoReverso = view.findViewById(R.id.tachaContratoReverso);

        btnImagenesGarantias = view.findViewById(R.id.btnCamaraGarantias);
        btnImagenesComprobantes = view.findViewById(R.id.btnCamaraComprobantes);

        btnImagenesIne = view.findViewById(R.id.btnCamaraIneCliente);
        btnImagenesContrato = view.findViewById(R.id.btnCamaraContrato);
        btnImagenesFoto = view.findViewById(R.id.btnCamaraFoto);
        btnImagenesFachada = view.findViewById(R.id.btnCamaraFachada);

        btnGuardarGarantiasRetiradas = view.findViewById(R.id.btnGuardarGarantiasRetiradasB);
        btnGuardarFotos = view.findViewById(R.id.btnGuardarFotosB);
        //btnUbicacion = view.findViewById(R.id.btnUbicacionB);

        btnCamGarantiasRetiradas = view.findViewById(R.id.btnCamGarantiasRetiradasB);

        btnUbicacionAval = view.findViewById(R.id.btnUbicacionAval);
        btnUbicacionCliente = view.findViewById(R.id.btnUbicacionCliente);

        btnUbicacionAval.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getCurrentLocation("aval");
                Toast.makeText(getContext(), "Ubicación del Aval Obtenida", Toast.LENGTH_LONG).show();
            }
        });

        btnUbicacionCliente.setOnClickListener(new View.OnClickListener() {
           @Override
           public void onClick(View v) {
               getCurrentLocation("cliente");
               Toast.makeText(getContext(), "Ubicación del Cliente Obtenida", Toast.LENGTH_LONG).show();
           }
       });

        archivosGeneral = new ArrayList<>();

        btnGuardarGarantiasRetiradas = view.findViewById(R.id.btnGuardarGarantiasRetiradasB);
        btnGuardarFotos = view.findViewById(R.id.btnGuardarFotosB);

        // Inicializar las listas AVAL
        pathsGarantiasAval = new ArrayList<>();
        pathsComprobantesAval = new ArrayList<>();
        pathsIneAval = new ArrayList<>();
        pathsFotoAval = new ArrayList<>();
        pathsFachadaAval = new ArrayList<>();

        pathsGarantiasAval2 = new ArrayList<>();
        pathsComprobantesAval2 = new ArrayList<>();
        pathsIneAval2 = new ArrayList<>();
        pathsFotoAval2 = new ArrayList<>();
        pathsFachadaAval2 = new ArrayList<>();

        imgIneFrenteA = view.findViewById(R.id.imagenIneFrenteAval);
        imgIneReversoA = view.findViewById(R.id.imagenIneReversoAval);
        tachaIneFrenteA = view.findViewById(R.id.tachaIneFrenteAval);
        tachaIneReversoA = view.findViewById(R.id.tachaIneReversoAval);

        imgComprobanteA = view.findViewById(R.id.imagenComprobanteAval);
        tachaComprobanteA = view.findViewById(R.id.tachaComprobanteAval);

        imgGarantia1A = view.findViewById(R.id.imagenGarantia1Aval);
        imgGarantia2A = view.findViewById(R.id.imagenGarantia2Aval);
        imgGarantia3A = view.findViewById(R.id.imagenGarantia3Aval);
        imgGarantia4A = view.findViewById(R.id.imagenGarantia4Aval);
        tachaGarantia1A = view.findViewById(R.id.tachaGarantia1Aval);
        tachaGarantia2A = view.findViewById(R.id.tachaGarantia2Aval);
        tachaGarantia3A = view.findViewById(R.id.tachaGarantia3Aval);
        tachaGarantia4A = view.findViewById(R.id.tachaGarantia4Aval);

        imgFotoA = view.findViewById(R.id.imagenFotoAval);
        tachaFotoA = view.findViewById(R.id.tachaFotoAval);

        imgFachadaA = view.findViewById(R.id.imagenFachadaAval);
        tachaFachadaA = view.findViewById(R.id.tachaFachadaAval);

        btnImagenesGarantiasAval = view.findViewById(R.id.btnCamaraGarantiasAval);
        btnImagenesComprobantesAval = view.findViewById(R.id.btnCamaraComprobantesAval);

        btnImagenesIneAval = view.findViewById(R.id.btnCamaraIneAval);
        btnImagenesFotoAval = view.findViewById(R.id.btnCamaraFotoAval);
        btnImagenesFachadaAval = view.findViewById(R.id.btnCamaraFachadaAval);

        tachaIneFrente.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialog("INE FRENTE", "¿Estás seguro de que deseas eliminar esta foto?", "0CC.jpeg");
            }
        });
        tachaIneReverso.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialog("INE REVERSO", "¿Estás seguro de que deseas eliminar esta foto?", "1CC.jpeg");
            }
        });
        tachaComprobante.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialog("COMPROBANTE", "¿Estás seguro de que deseas eliminar esta foto?", "2CC.jpeg");
            }
        });
        tachaContratoFrente.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialog("CONTRATO FRENTE", "¿Estás seguro de que deseas eliminar esta foto?", "3CC.jpeg");
            }
        });
        tachaContratoReverso.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialog("CONTRATO REVERSO", "¿Estás seguro de que deseas eliminar esta foto?", "4CC.jpeg");
            }
        });
        tachaGarantia1.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialog("GARANTIA", "¿Estás seguro de que deseas eliminar esta foto?", "0GC.jpeg");
            }
        });
        tachaGarantia2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialog("GARANTIA", "¿Estás seguro de que deseas eliminar esta foto?", "1GC.jpeg");
            }
        });
        tachaGarantia3.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialog("GARANTIA", "¿Estás seguro de que deseas eliminar esta foto?", "2GC.jpeg");
            }
        });
        tachaGarantia4.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialog("GARANTIA", "¿Estás seguro de que deseas eliminar esta foto?", "3GC.jpeg");
            }
        });
        tachaFoto.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialog("FOTO DE CLIENTE", "¿Estás seguro de que deseas eliminar esta foto?", "5CC.jpeg");
            }
        });
        tachaFechada.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialog("FACHADA", "¿Estás seguro de que deseas eliminar esta foto?", "6CC.jpeg");
            }
        });

        //CODIGO TACHA(BORRAR FOTOS) EN AVALES
        tachaIneFrenteA.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialogAval("INE FRENTE", "¿Estás seguro de que deseas eliminar esta foto?", "0CA.jpeg");
            }
        });
        tachaIneReversoA.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialogAval("INE REVERSO", "¿Estás seguro de que deseas eliminar esta foto?", "1CA.jpeg");
            }
        });
        tachaComprobanteA.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialogAval("COMPROBANTE DE DOMICILIO", "¿Estás seguro de que deseas eliminar esta foto?", "2CA.jpeg");
            }
        });
        tachaGarantia1A.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialogAval("GARANTIA 1", "¿Estás seguro de que deseas eliminar esta foto?", "0GA.jpeg");
            }
        });
        tachaGarantia2A.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialogAval("GARANTIA 2", "¿Estás seguro de que deseas eliminar esta foto?", "1GA.jpeg");
            }
        });
        tachaGarantia3A.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialogAval("GARANTIA 3", "¿Estás seguro de que deseas eliminar esta foto?", "2GA.jpeg");
            }
        });
        tachaGarantia4A.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialogAval("GARANTIA 4", "¿Estás seguro de que deseas eliminar esta foto?", "3GA.jpeg");
            }
        });
        tachaFotoA.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialogAval("FOTO DE AVAL", "¿Estás seguro de que deseas eliminar esta foto?", "3CA.jpeg");
            }
        });
        tachaFachadaA.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showConfirmationDialogAval("FACHADA", "¿Estás seguro de que deseas eliminar esta foto?", "4CA.jpeg");
            }
        });

        btnGuardarGarantiasRetiradas.setOnClickListener(view1 -> {
            if (pathsGarantiasRetiradas.size() == 0) {
                new MaterialAlertDialogBuilder(getActivity())
                        .setTitle("Aviso")
                        .setMessage("No se han subido fotos de garantías retiradas para subir")
                        .setPositiveButton("Ok", (dialogInterface, i) -> {
                        })
                        .show();
            } else {
                if(dateEdt.getText().toString().equals("")){
                    new MaterialAlertDialogBuilder(getActivity())
                            .setTitle("Aviso")
                            .setMessage("Debes seleccionar una fecha de pago")
                            .setPositiveButton("Ok", (dialogInterface, i) -> {
                            })
                            .show();
                } else if (etDescGarantia.getText().toString().trim().isEmpty()) {
                    new MaterialAlertDialogBuilder(getActivity())
                            .setTitle("Aviso")
                            .setMessage("Debes ingresar una descripción de la garantía")
                            .setPositiveButton("Ok", (dialogInterface, i) -> {
                            })
                            .show();
                } else {
                    subirGarantiasRetiradas();
                }
            }
        });

        btnCamGarantiasRetiradas.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:
                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {
                                    camaraGarantiasClienteAbierta = false;
                                    camaraComprobantesClienteAbierta = false;
                                    camaraGarantiasRetiradas = true;

                                    camaraIneClienteAbierta = false;
                                    camaraContratoClienteAbierta = false;
                                    camaraFotoAbierta = false;
                                    camaraFachadaAbierta = false;

                                    camaraGarantiasAvalAbierta = false;
                                    camaraComprobantesAvalAbierta = false;
                                    camaraIneAvalAbierta = false;
                                    camaraFotoAvalAbierta = false;
                                    camaraFachadaAvalAbierta = false;

                                    openCameraIntent();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }
                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = false;
                                camaraComprobantesClienteAbierta = false;
                                camaraGarantiasRetiradas = true;

                                camaraIneClienteAbierta = false;
                                camaraContratoClienteAbierta = false;
                                camaraFotoAbierta = false;
                                camaraFachadaAbierta = false;

                                camaraGarantiasAvalAbierta = false;
                                camaraComprobantesAvalAbierta = false;
                                camaraIneAvalAbierta = false;
                                camaraFotoAvalAbierta = false;
                                camaraFachadaAvalAbierta = false;

                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();
            }
        });

        btnImagenesGarantias.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:


                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {
                                    camaraGarantiasClienteAbierta = true;
                                    camaraComprobantesClienteAbierta = false;
                                    camaraGarantiasRetiradas = false;

                                    camaraIneClienteAbierta = false;
                                    camaraContratoClienteAbierta = false;
                                    camaraFotoAbierta = false;
                                    camaraFachadaAbierta = false;

                                    camaraGarantiasAvalAbierta = false;
                                    camaraComprobantesAvalAbierta = false;
                                    camaraIneAvalAbierta = false;
                                    camaraFotoAvalAbierta = false;
                                    camaraFachadaAvalAbierta = false;

                                    openCameraIntent();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }

                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = true;
                                camaraComprobantesClienteAbierta = false;
                                camaraGarantiasRetiradas = false;

                                camaraIneClienteAbierta = false;
                                camaraContratoClienteAbierta = false;
                                camaraFotoAbierta = false;
                                camaraFachadaAbierta = false;

                                camaraGarantiasAvalAbierta = false;
                                camaraComprobantesAvalAbierta = false;
                                camaraIneAvalAbierta = false;
                                camaraFotoAvalAbierta = false;
                                camaraFachadaAvalAbierta = false;
                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();

            }
        });

        btnImagenesComprobantes.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:
                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {
                                    camaraGarantiasClienteAbierta = false;
                                    camaraComprobantesClienteAbierta = true;
                                    camaraGarantiasRetiradas = false;

                                    camaraIneClienteAbierta = false;
                                    camaraContratoClienteAbierta = false;
                                    camaraFotoAbierta = false;
                                    camaraFachadaAbierta = false;

                                    camaraGarantiasAvalAbierta = false;
                                    camaraComprobantesAvalAbierta = false;
                                    camaraIneAvalAbierta = false;
                                    camaraFotoAvalAbierta = false;
                                    camaraFachadaAvalAbierta = false;

                                    //openCameraIntent();
                                    openCameraModal();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }
                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = false;
                                camaraComprobantesClienteAbierta = true;
                                camaraGarantiasRetiradas = false;

                                camaraIneClienteAbierta = false;
                                camaraContratoClienteAbierta = false;
                                camaraFotoAbierta = false;
                                camaraFachadaAbierta = false;

                                camaraGarantiasAvalAbierta = false;
                                camaraComprobantesAvalAbierta = false;
                                camaraIneAvalAbierta = false;
                                camaraFotoAvalAbierta = false;
                                camaraFachadaAvalAbierta = false;

                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();
            }
        });

        btnImagenesIne.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:
                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {
                                    camaraGarantiasClienteAbierta = false;
                                    camaraComprobantesClienteAbierta = false;
                                    camaraGarantiasRetiradas = false;

                                    camaraIneClienteAbierta = true;
                                    camaraContratoClienteAbierta = false;
                                    camaraFotoAbierta = false;
                                    camaraFachadaAbierta = false;

                                    camaraGarantiasAvalAbierta = false;
                                    camaraComprobantesAvalAbierta = false;
                                    camaraIneAvalAbierta = false;
                                    camaraFotoAvalAbierta = false;
                                    camaraFachadaAvalAbierta = false;

                                    //openCameraIntent();
                                    openCameraModal();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }
                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = false;
                                camaraComprobantesClienteAbierta = false;
                                camaraGarantiasRetiradas = false;

                                camaraIneClienteAbierta = true;
                                camaraContratoClienteAbierta = false;
                                camaraFotoAbierta = false;
                                camaraFachadaAbierta = false;

                                camaraGarantiasAvalAbierta = false;
                                camaraComprobantesAvalAbierta = false;
                                camaraIneAvalAbierta = false;
                                camaraFotoAvalAbierta = false;
                                camaraFachadaAvalAbierta = false;

                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();
            }
        });

        btnImagenesContrato.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:
                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {
                                    camaraGarantiasClienteAbierta = false;
                                    camaraComprobantesClienteAbierta = false;
                                    camaraGarantiasRetiradas = false;

                                    camaraIneClienteAbierta = false;
                                    camaraContratoClienteAbierta = true;
                                    camaraFotoAbierta = false;
                                    camaraFachadaAbierta = false;

                                    camaraGarantiasAvalAbierta = false;
                                    camaraComprobantesAvalAbierta = false;
                                    camaraIneAvalAbierta = false;
                                    camaraFotoAvalAbierta = false;
                                    camaraFachadaAvalAbierta = false;

                                    //openCameraIntent();
                                    openCameraModal();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }
                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = false;
                                camaraComprobantesClienteAbierta = false;
                                camaraGarantiasRetiradas = false;

                                camaraIneClienteAbierta = false;
                                camaraContratoClienteAbierta = true;
                                camaraFotoAbierta = false;
                                camaraFachadaAbierta = false;

                                camaraGarantiasAvalAbierta = false;
                                camaraComprobantesAvalAbierta = false;
                                camaraIneAvalAbierta = false;
                                camaraFotoAvalAbierta = false;
                                camaraFachadaAvalAbierta = false;

                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();
            }
        });

        btnImagenesFoto.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:
                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {
                                    camaraGarantiasClienteAbierta = false;
                                    camaraComprobantesClienteAbierta = false;
                                    camaraGarantiasRetiradas = false;

                                    camaraIneClienteAbierta = false;
                                    camaraContratoClienteAbierta = false;
                                    camaraFotoAbierta = true;
                                    camaraFachadaAbierta = false;

                                    camaraGarantiasAvalAbierta = false;
                                    camaraComprobantesAvalAbierta = false;
                                    camaraIneAvalAbierta = false;
                                    camaraFotoAvalAbierta = false;
                                    camaraFachadaAvalAbierta = false;

                                    openCameraIntent();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }
                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = false;
                                camaraComprobantesClienteAbierta = false;
                                camaraGarantiasRetiradas = false;

                                camaraIneClienteAbierta = false;
                                camaraContratoClienteAbierta = false;
                                camaraFotoAbierta = true;
                                camaraFachadaAbierta = false;

                                camaraGarantiasAvalAbierta = false;
                                camaraComprobantesAvalAbierta = false;
                                camaraIneAvalAbierta = false;
                                camaraFotoAvalAbierta = false;
                                camaraFachadaAvalAbierta = false;

                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();
            }
        });

        btnImagenesFachada.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:
                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {
                                    camaraGarantiasClienteAbierta = false;
                                    camaraComprobantesClienteAbierta = false;
                                    camaraGarantiasRetiradas = false;

                                    camaraIneClienteAbierta = false;
                                    camaraContratoClienteAbierta = false;
                                    camaraFotoAbierta = false;
                                    camaraFachadaAbierta = true;

                                    camaraGarantiasAvalAbierta = false;
                                    camaraComprobantesAvalAbierta = false;
                                    camaraIneAvalAbierta = false;
                                    camaraFotoAvalAbierta = false;
                                    camaraFachadaAvalAbierta = false;

                                    openCameraIntent();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }
                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = false;
                                camaraComprobantesClienteAbierta = false;
                                camaraGarantiasRetiradas = false;

                                camaraIneClienteAbierta = false;
                                camaraContratoClienteAbierta = false;
                                camaraFotoAbierta = false;
                                camaraFachadaAbierta = true;

                                camaraGarantiasAvalAbierta = false;
                                camaraComprobantesAvalAbierta = false;
                                camaraIneAvalAbierta = false;
                                camaraFotoAvalAbierta = false;
                                camaraFachadaAvalAbierta = false;

                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();
            }
        });

        //BOTONES CAMARA DE AVAL:
        btnImagenesIneAval.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:
                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {

                                    camaraGarantiasClienteAbierta = false;
                                    camaraComprobantesClienteAbierta = false;
                                    camaraGarantiasRetiradas = false;
                                    camaraIneClienteAbierta = false;
                                    camaraContratoClienteAbierta = false;
                                    camaraFotoAbierta = false;
                                    camaraFachadaAbierta = false;

                                    camaraIneAvalAbierta = true;
                                    camaraGarantiasAvalAbierta = false;
                                    camaraComprobantesAvalAbierta = false;
                                    camaraFotoAvalAbierta = false;
                                    camaraFachadaAvalAbierta = false;

                                    //openCameraIntent();
                                    openCameraModal();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }
                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = false;
                                camaraComprobantesClienteAbierta = false;
                                camaraGarantiasRetiradas = false;
                                camaraIneClienteAbierta = false;
                                camaraContratoClienteAbierta = false;
                                camaraFotoAbierta = false;
                                camaraFachadaAbierta = false;

                                camaraIneAvalAbierta = true;
                                camaraGarantiasAvalAbierta = false;
                                camaraComprobantesAvalAbierta = false;
                                camaraFotoAvalAbierta = false;
                                camaraFachadaAvalAbierta = false;

                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();
            }
        });

        btnImagenesComprobantesAval.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:
                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {
                                    camaraGarantiasClienteAbierta = false;
                                    camaraComprobantesClienteAbierta = false;
                                    camaraGarantiasRetiradas = false;
                                    camaraIneClienteAbierta = false;
                                    camaraContratoClienteAbierta = false;
                                    camaraFotoAbierta = false;
                                    camaraFachadaAbierta = false;

                                    camaraComprobantesAvalAbierta = true;
                                    camaraGarantiasAvalAbierta = false;

                                    camaraIneAvalAbierta = false;
                                    camaraFotoAvalAbierta = false;
                                    camaraFachadaAvalAbierta = false;

                                    //openCameraIntent();
                                    openCameraModal();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }
                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = false;
                                camaraComprobantesClienteAbierta = false;
                                camaraGarantiasRetiradas = false;
                                camaraIneClienteAbierta = false;
                                camaraContratoClienteAbierta = false;
                                camaraFotoAbierta = false;
                                camaraFachadaAbierta = false;

                                camaraComprobantesAvalAbierta = true;
                                camaraGarantiasAvalAbierta = false;

                                camaraIneAvalAbierta = false;
                                camaraFotoAvalAbierta = false;
                                camaraFachadaAvalAbierta = false;

                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();
            }
        });

        btnImagenesGarantiasAval.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:
                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {

                                    camaraGarantiasClienteAbierta = false;
                                    camaraComprobantesClienteAbierta = false;
                                    camaraGarantiasRetiradas = false;
                                    camaraIneClienteAbierta = false;
                                    camaraContratoClienteAbierta = false;
                                    camaraFotoAbierta = false;
                                    camaraFachadaAbierta = false;

                                    camaraComprobantesAvalAbierta = false;
                                    camaraGarantiasAvalAbierta = true;

                                    camaraIneAvalAbierta = false;
                                    camaraFotoAvalAbierta = false;
                                    camaraFachadaAvalAbierta = false;

                                    openCameraIntent();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }
                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = false;
                                camaraComprobantesClienteAbierta = false;
                                camaraGarantiasRetiradas = false;
                                camaraIneClienteAbierta = false;
                                camaraContratoClienteAbierta = false;
                                camaraFotoAbierta = false;
                                camaraFachadaAbierta = false;

                                camaraComprobantesAvalAbierta = false;
                                camaraGarantiasAvalAbierta = true;

                                camaraIneAvalAbierta = false;
                                camaraFotoAvalAbierta = false;
                                camaraFachadaAvalAbierta = false;

                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();
            }
        });

        btnImagenesFotoAval.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:
                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {

                                    camaraGarantiasClienteAbierta = false;
                                    camaraComprobantesClienteAbierta = false;
                                    camaraGarantiasRetiradas = false;
                                    camaraIneClienteAbierta = false;
                                    camaraContratoClienteAbierta = false;
                                    camaraFotoAbierta = false;
                                    camaraFachadaAbierta = false;

                                    camaraComprobantesAvalAbierta = false;
                                    camaraGarantiasAvalAbierta = false;

                                    camaraIneAvalAbierta = false;
                                    camaraFotoAvalAbierta = true;
                                    camaraFachadaAvalAbierta = false;

                                    openCameraIntent();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }
                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = false;
                                camaraComprobantesClienteAbierta = false;
                                camaraGarantiasRetiradas = false;
                                camaraIneClienteAbierta = false;
                                camaraContratoClienteAbierta = false;
                                camaraFotoAbierta = false;
                                camaraFachadaAbierta = false;

                                camaraComprobantesAvalAbierta = false;
                                camaraGarantiasAvalAbierta = false;

                                camaraIneAvalAbierta = false;
                                camaraFotoAvalAbierta = true;
                                camaraFachadaAvalAbierta = false;

                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();
            }
        });

        btnImagenesFachadaAval.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("Seleccionar imagen");

                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int which) {
                        switch (which) {
                            case 0:
                                int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
                                int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {

                                    camaraGarantiasClienteAbierta = false;
                                    camaraComprobantesClienteAbierta = false;
                                    camaraGarantiasRetiradas = false;
                                    camaraIneClienteAbierta = false;
                                    camaraContratoClienteAbierta = false;
                                    camaraFotoAbierta = false;
                                    camaraFachadaAbierta = false;

                                    camaraComprobantesAvalAbierta = false;
                                    camaraGarantiasAvalAbierta = false;

                                    camaraIneAvalAbierta = false;
                                    camaraFotoAvalAbierta = false;
                                    camaraFachadaAvalAbierta = true;

                                    openCameraIntent();
                                } else {
                                    ActivityCompat.requestPermissions(getActivity(),
                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                            CODIGO_PERMISOS_CAMARA);
                                }
                                break;
                            case 1:
                                camaraGarantiasClienteAbierta = false;
                                camaraComprobantesClienteAbierta = false;
                                camaraGarantiasRetiradas = false;
                                camaraIneClienteAbierta = false;
                                camaraContratoClienteAbierta = false;
                                camaraFotoAbierta = false;
                                camaraFachadaAbierta = false;

                                camaraComprobantesAvalAbierta = false;
                                camaraGarantiasAvalAbierta = false;

                                camaraIneAvalAbierta = false;
                                camaraFotoAvalAbierta = false;
                                camaraFachadaAvalAbierta = true;

                                openGalleryIntent();
                                break;
                        }
                    }
                });
                builder.show();
            }
        });

        btnGuardarFotos.setOnClickListener(view15 -> {

            if (pathsComprobantesCliente.size() == 0 && pathsGarantiasCliente.size() == 0 &&
                    pathsIneCliente.size() == 0 && pathsFotoCliente.size() == 0 && pathsContratoCliente.size() == 0 && pathsFachadaCliente.size() == 0 && lat.equals("") && lgt.equals("")) {

                new MaterialAlertDialogBuilder(getActivity())
                        .setTitle("Aviso")
                        .setMessage("No se han tomado fotos para subir")
                        .setPositiveButton("Ok", (dialogInterface, i) -> {})
                        .show();
            } else {
                if (cliente == null) {
                    // Crear un Bundle para pasar las listas de fotos
                    Bundle bundle = new Bundle();
                    bundle.putStringArrayList("pathsComprobantesCliente", pathsComprobantesCliente);
                    bundle.putStringArrayList("pathsGarantiasCliente", pathsGarantiasCliente);
                    bundle.putStringArrayList("pathsIneCliente", pathsIneCliente);
                    bundle.putStringArrayList("pathsFotoCliente", pathsFotoCliente);
                    bundle.putStringArrayList("pathsContratoCliente", pathsContratoCliente);
                    bundle.putStringArrayList("pathsFachadaCliente", pathsFachadaCliente);

// Verifica que el fragmento padre implemente la interfaz
                    Fragment parentFragment = getParentFragment();
                    if (parentFragment instanceof OnPhotosSelectedListener) {
                        listener = (OnPhotosSelectedListener) parentFragment;
                    } else {
                        throw new ClassCastException(parentFragment.toString() + " must implement OnPhotosSelectedListener");
                    }
                    // Llama al método del listener para pasar los datos
                    if (listener != null) {
                        listener.onPhotosSelected(
                                pathsComprobantesCliente,
                                pathsGarantiasCliente,
                                pathsIneCliente,
                                pathsFotoCliente,
                                pathsContratoCliente,
                                pathsFachadaCliente,
                                archivosGeneral
                        );
                    }
                } else {
                    subirFotos();
                }
            }
        });
/*
        btnUbicacion.setOnClickListener(view16 -> {
            getCurrentLocation();
            btnUbicacion.setText("Ubicación obtenida");
        });
*/
        // Añadir archivos de pathsComprobantesCliente
        for (String path : pathsComprobantesCliente) {
            File file = new File(path);
            if (file.exists()) {
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                MultipartBody.Part body = MultipartBody.Part.createFormData("comprobante", file.getName(), requestFile);
                archivosGeneral.add(body);
            } else {
                Log.d("log", "El archivo no existe: " + path);
            }
        }

        // Añadir archivos de pathsGarantiasCliente
        for (String path : pathsGarantiasCliente) {
            File file = new File(path);
            if (file.exists()) {
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                MultipartBody.Part body = MultipartBody.Part.createFormData("garantia", file.getName(), requestFile);
                archivosGeneral.add(body);
            } else {
                Log.d("log", "El archivo no existe: " + path);
            }
        }

        // Añadir archivos de pathsIneCliente
        for (String path : pathsIneCliente) {
            File file = new File(path);
            if (file.exists()) {
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                MultipartBody.Part body = MultipartBody.Part.createFormData("ine", file.getName(), requestFile);
                archivosGeneral.add(body);
            } else {
                Log.d("log", "El archivo no existe: " + path);
            }
        }

        // Añadir archivos de pathsFotoCliente
        for (String path : pathsFotoCliente) {
            File file = new File(path);
            if (file.exists()) {
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                MultipartBody.Part body = MultipartBody.Part.createFormData("foto", file.getName(), requestFile);
                archivosGeneral.add(body);
            } else {
                Log.d("log", "El archivo no existe: " + path);
            }
        }

        // Añadir archivos de pathsFotoCliente
        for (String path : pathsContratoCliente) {
            File file = new File(path);
            if (file.exists()) {
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                MultipartBody.Part body = MultipartBody.Part.createFormData("contrato", file.getName(), requestFile);
                archivosGeneral.add(body);
            } else {
                Log.d("log", "El archivo no existe: " + path);
            }
        }

        // Añadir archivos de pathsFachadaCliente
        for (String path : pathsFachadaCliente) {
            File file = new File(path);
            if (file.exists()) {
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                MultipartBody.Part body = MultipartBody.Part.createFormData("fachada", file.getName(), requestFile);
                archivosGeneral.add(body);
            } else {
                Log.d("log", "El archivo no existe: " + path);
            }
        }

        // Añadir archivos de AVAL
        // Añadir archivos de pathsComprobantesAval
        for (String path : pathsComprobantesAval) {
            File file = new File(path);
            if (file.exists()) {
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                MultipartBody.Part body = MultipartBody.Part.createFormData("comprobante", file.getName(), requestFile);
                archivosGeneral.add(body);
            } else {
                Log.d("log", "El archivo no existe: " + path);
            }
        }

        // Añadir archivos de pathsGarantiasAval
        for (String path : pathsGarantiasAval) {
            File file = new File(path);
            if (file.exists()) {
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                MultipartBody.Part body = MultipartBody.Part.createFormData("garantia", file.getName(), requestFile);
                archivosGeneral.add(body);
            } else {
                Log.d("log", "El archivo no existe: " + path);
            }
        }

        // Añadir archivos de pathsIneAval
        for (String path : pathsIneAval) {
            File file = new File(path);
            if (file.exists()) {
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                MultipartBody.Part body = MultipartBody.Part.createFormData("ine", file.getName(), requestFile);
                archivosGeneral.add(body);
            } else {
                Log.d("log", "El archivo no existe: " + path);
            }
        }

        // Añadir archivos de pathsFotoAval
        for (String path : pathsFotoAval) {
            File file = new File(path);
            if (file.exists()) {
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                MultipartBody.Part body = MultipartBody.Part.createFormData("foto", file.getName(), requestFile);
                archivosGeneral.add(body);
            } else {
                Log.d("log", "El archivo no existe: " + path);
            }
        }

        // Añadir archivos de pathsFachadaAval
        for (String path : pathsFachadaAval) {
            File file = new File(path);
            if (file.exists()) {
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                MultipartBody.Part body = MultipartBody.Part.createFormData("fachada", file.getName(), requestFile);
                archivosGeneral.add(body);
            } else {
                Log.d("log", "El archivo no existe: " + path);
            }
        }
    }
    private void showConfirmationDialog(String title, String message, String fileName) {
        new AlertDialog.Builder(getActivity())
                .setTitle(title)
                .setMessage(message)
                .setPositiveButton("Sí", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        // Llama al método para eliminar la imagen del servidor
                        if (cliente != null) {
                            deleteImageFromServer(fileName);
                        }
                        else {
                            deleteImageFromServer(fileName);
                        }
                    }
                })
                .setNegativeButton("No", null)
                .show();
    }

    private void showConfirmationDialogAval(String title, String message, String fileName) {
        new AlertDialog.Builder(getActivity())
                .setTitle(title)
                .setMessage(message)
                .setPositiveButton("Sí", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        // Llama al método para eliminar la imagen del servidor
                        if (avalId != null) {
                            deleteImageFromServerAval(fileName);
                        } else {
                            handleImageDeletionUIAval(fileName);
                        }

                    }
                })
                .setNegativeButton("No", null)
                .show();
    }

    public void deleteImageFromServer(String fileName) {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Eliminando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        String cliente_comprobante = "comprobantes/clientes/" + cliente.getId() + "_" + cliente.getNombre_completo();
        String cliente_garantias = "garantias/clientes/" + cliente.getId() + "_" + cliente.getNombre_completo();

        String cliente_ruta;
        if (fileName.contains("CC")) {
            cliente_ruta = "../../resources/" + cliente_comprobante; // Ruta relativa para comprobante
        } else {
            cliente_ruta = "../../resources/" + cliente_garantias; // Ruta relativa para garantía
        }

        vs = VolleyS.getInstance(this.getContext());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "deleteArchivo");
            data.put("ruta", cliente_ruta);
            data.put("nombre", fileName);

            // LOG: Verificar datos enviados al servidor
            Log.d("deleteImageFromServer", "Data enviado: " + data);

        } catch (JSONException e) {
            e.printStackTrace();
        }

        Log.d("6", "loadAllData: ");

        // Crear la solicitud JSON
        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            // LOG: Verificar respuesta del servidor
                            Log.d("deleteImageFromServer", "Respuesta del servidor: " + response.toString());

                            if (response.getBoolean("success")) {
                                Log.d("deleteImageFromServer", "Imagen eliminada exitosamente: " + fileName);
                                // Lógica para actualizar UI
                                handleImageDeletionUI(fileName);
                                dialog.cancel();
                            } else {
                                // LOG: Verificar mensaje de error desde el servidor
                                Log.e("deleteImageFromServer", "Error al eliminar la imagen: " + response.getString("message"));
                                handleImageDeletionUI(fileName);
                                dialog.cancel();
                            }
                        } catch (JSONException e) {
                            dialog.cancel();
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                // LOG: Verificar error en la solicitud
                Log.e("deleteImageFromServer", "Error en la solicitud: " + error.getMessage());
                ErrorChecker.checker(error, getActivity()); // Manejo de error
                handleImageDeletionUI(fileName);
                dialog.cancel();
            }
        });

        // Configurar la política de reintento si es necesario
        request.setRetryPolicy(new DefaultRetryPolicy(
                5000, // Timeout en milisegundos
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        // LOG: Verificar que la solicitud se agrega a la cola
        Log.d("deleteImageFromServer", "Agregando la solicitud a la cola");

        // Agregar la solicitud a la cola
        requestQueue.add(request);
    }

    private void handleImageDeletionUI(String fileName) {
        String itemToRemove = null;

        switch (fileName) {
            // GARANTÍAS
            case "0GC.jpeg":
                imgGarantia1.setImageDrawable(null);
                imgGarantia1.setVisibility(View.GONE);

                // Buscar y eliminar la ruta completa de pathsGarantiasCliente
                for (String path : pathsGarantiasCliente) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }
                if (itemToRemove != null) {
                    pathsGarantiasCliente.remove(itemToRemove);
                }
                break;

            case "1GC.jpeg":
                imgGarantia2.setImageDrawable(null);
                imgGarantia2.setVisibility(View.GONE);

                for (String path : pathsGarantiasCliente) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }
                if (itemToRemove != null) {
                    pathsGarantiasCliente.remove(itemToRemove);
                }
                break;

            case "2GC.jpeg":
                imgGarantia3.setImageDrawable(null);
                imgGarantia3.setVisibility(View.GONE);

                for (String path : pathsGarantiasCliente) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }
                if (itemToRemove != null) {
                    pathsGarantiasCliente.remove(itemToRemove);
                }
                break;

            case "3GC.jpeg":
                imgGarantia4.setImageDrawable(null);
                imgGarantia4.setVisibility(View.GONE);

                for (String path : pathsGarantiasCliente) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }
                if (itemToRemove != null) {
                    pathsGarantiasCliente.remove(itemToRemove);
                }
                break;

            // INE Cliente
            case "0CC.jpeg":
                imgIneFrente.setImageDrawable(null);
                imgIneFrente.setVisibility(View.GONE);

                for (String path : pathsIneCliente) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }
                if (itemToRemove != null) {
                    pathsIneCliente.remove(itemToRemove);
                }
                break;

            case "1CC.jpeg":
                imgIneReverso.setImageDrawable(null);
                imgIneReverso.setVisibility(View.GONE);

                for (String path : pathsIneCliente) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }
                if (itemToRemove != null) {
                    pathsIneCliente.remove(itemToRemove);
                }
                break;

            // Comprobante Cliente
            case "2CC.jpeg":
                imgComprobante.setImageDrawable(null);
                imgComprobante.setVisibility(View.GONE);

                for (String path : pathsComprobantesCliente) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }
                if (itemToRemove != null) {
                    pathsComprobantesCliente.remove(itemToRemove);
                }
                break;

            // Contrato Cliente
            case "3CC.jpeg":
                imgContratoFrente.setImageDrawable(null);
                imgContratoFrente.setVisibility(View.GONE);

                for (String path : pathsContratoCliente) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }
                if (itemToRemove != null) {
                    pathsContratoCliente.remove(itemToRemove);
                }
                break;

            case "4CC.jpeg":
                imgContratoReverso.setImageDrawable(null);
                imgContratoReverso.setVisibility(View.GONE);

                for (String path : pathsContratoCliente) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }
                if (itemToRemove != null) {
                    pathsContratoCliente.remove(itemToRemove);
                }
                break;

            // Foto Cliente
            case "5CC.jpeg":
                imgFoto.setImageDrawable(null);
                imgFoto.setVisibility(View.GONE);

                for (String path : pathsFotoCliente) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }
                if (itemToRemove != null) {
                    pathsFotoCliente.remove(itemToRemove);
                }
                break;

            case "6CC.jpeg":
                imgFachada.setImageDrawable(null);
                imgFachada.setVisibility(View.GONE);

                for (String path : pathsFachadaCliente) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }
                if (itemToRemove != null) {
                    pathsFachadaCliente.remove(itemToRemove);
                }
                break;
        }
    }

    public void deleteImageFromServerAval(String fileName) {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Eliminando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        String aval_comprobante = "comprobantes/avales/" + avalId + "_" + aval_nombre;
        String aval_garantias = "garantias/avales/" + avalId + "_" + aval_nombre;
        Log.d("deleteFromServerAval", "ENTRO EN BORRAR FOTO EN SERVER AVAL................... ");
        String aval_ruta;
        if (fileName.contains("CA")) {
            aval_ruta = "../../resources/" + aval_comprobante; // Ruta relativa para comprobante
        } else {
            aval_ruta = "../../resources/" + aval_garantias; // Ruta relativa para garantía
        }

        vs = VolleyS.getInstance(this.getContext());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "deleteArchivo");
            data.put("ruta", aval_ruta);
            data.put("nombre", fileName);

            // LOG: Verificar datos enviados al servidor
            Log.d("deleteImageFromServer", "Data enviado: " + data);

        } catch (JSONException e) {
            e.printStackTrace();
        }

        // Crear la solicitud JSON
        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlAvales, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            // LOG: Verificar respuesta del servidor
                            Log.d("deleteImageFromServer", "Respuesta del servidor: " + response.toString());

                            if (response.getBoolean("success")) {
                                Log.d("deleteImageFromServer", "Imagen eliminada exitosamente: " + fileName);
                                // Lógica para actualizar UI
                                handleImageDeletionUIAval(fileName);
                                dialog.cancel();
                            } else {
                                // LOG: Verificar mensaje de error desde el servidor
                                Log.e("deleteImageFromServer", "Error al eliminar la imagen: " + response.getString("message"));
                                handleImageDeletionUIAval(fileName);
                                dialog.cancel();
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                // LOG: Verificar error en la solicitud
                Log.e("deleteImageFromServer", "Error en la solicitud: " + error.getMessage());
                //ErrorChecker.checker(error, getActivity()); // Manejo de error
                handleImageDeletionUIAval(fileName);
                dialog.cancel();
            }
        });

        // Configurar la política de reintento si es necesario
        request.setRetryPolicy(new DefaultRetryPolicy(
                5000, // Timeout en milisegundos
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        // LOG: Verificar que la solicitud se agrega a la cola
        Log.d("deleteImageFromServer", "Agregando la solicitud a la cola");

        // Agregar la solicitud a la cola
        requestQueue.add(request);
    }


    private void handleImageDeletionUIAval(String fileName) {
        // Variable para almacenar el archivo que vamos a eliminar
        String itemToRemove = null;

        switch (fileName) {
            case "0CA.jpeg":
                imgIneFrenteA.setImageDrawable(null);
                imgIneFrenteA.setVisibility(View.GONE);

                // Buscar en pathsIneAval la ruta que contenga "0CA.jpeg"
                for (String path : pathsIneAval) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }

                // Eliminar la ruta completa
                if (itemToRemove != null) {
                    pathsIneAval.remove(itemToRemove);
                    Log.d("MOD", "Archivo pathsIneAval 0CA eliminado: " + itemToRemove);
                    Log.d("MOD", "Archivo pathsIneAval size: " + pathsIneAval.size());
                } else {
                    Log.d("MOD", "Archivo pathsIneAval 0CA no encontrado");
                }
                break;

            case "1CA.jpeg":
                imgIneReversoA.setImageDrawable(null);
                imgIneReversoA.setVisibility(View.GONE);

                // Buscar en pathsIneAval la ruta que contenga "1CA.jpeg"
                for (String path : pathsIneAval) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }

                // Eliminar la ruta completa
                if (itemToRemove != null) {
                    pathsIneAval.remove(itemToRemove);
                    Log.d("MOD", "Archivo pathsIneAval 1CA eliminado: " + itemToRemove);
                    Log.d("MOD", "Archivo pathsIneAval size: " + pathsIneAval.size());
                } else {
                    Log.d("MOD", "Archivo pathsIneAval 1CA no encontrado");
                }
                break;

            case "2CA.jpeg":
                imgComprobanteA.setImageDrawable(null);
                imgComprobanteA.setVisibility(View.GONE);

                // Buscar y eliminar el archivo de pathsComprobantesAval
                for (String path : pathsComprobantesAval) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }

                if (itemToRemove != null) {
                    pathsComprobantesAval.remove(itemToRemove);
                    Log.d("MOD", "Archivo pathsComprobantesAval 2CA eliminado: " + itemToRemove);
                } else {
                    Log.d("MOD", "Archivo pathsComprobantesAval 2CA no encontrado");
                }
                break;

            case "3CA.jpeg":
                imgFotoA.setImageDrawable(null);
                imgFotoA.setVisibility(View.GONE);

                // Buscar y eliminar el archivo de pathsFotoAval
                for (String path : pathsFotoAval) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }

                if (itemToRemove != null) {
                    pathsFotoAval.remove(itemToRemove);
                    Log.d("MOD", "Archivo pathsFotoAval 3CA eliminado: " + itemToRemove);
                } else {
                    Log.d("MOD", "Archivo pathsFotoAval 3CA no encontrado");
                }
                break;

            case "4CA.jpeg":
                imgFachadaA.setImageDrawable(null);
                imgFachadaA.setVisibility(View.GONE);

                // Buscar y eliminar el archivo de pathsFachadaAval
                for (String path : pathsFachadaAval) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }

                if (itemToRemove != null) {
                    pathsFachadaAval.remove(itemToRemove);
                    Log.d("MOD", "Archivo pathsFachadaAval 4CA eliminado: " + itemToRemove);
                } else {
                    Log.d("MOD", "Archivo pathsFachadaAval 4CA no encontrado");
                }
                break;

            case "0GA.jpeg":
                imgGarantia1A.setImageDrawable(null);
                imgGarantia1A.setVisibility(View.GONE);

                // Buscar y eliminar el archivo de pathsGarantiasAval
                for (String path : pathsGarantiasAval) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }

                if (itemToRemove != null) {
                    pathsGarantiasAval.remove(itemToRemove);
                    Log.d("MOD", "Archivo pathsGarantiasAval 0GA eliminado: " + itemToRemove);
                } else {
                    Log.d("MOD", "Archivo pathsGarantiasAval 0GA no encontrado");
                }
                break;

            case "1GA.jpeg":
                imgGarantia2A.setImageDrawable(null);
                imgGarantia2A.setVisibility(View.GONE);

                // Buscar y eliminar el archivo de pathsGarantiasAval
                for (String path : pathsGarantiasAval) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }

                if (itemToRemove != null) {
                    pathsGarantiasAval.remove(itemToRemove);
                    Log.d("MOD", "Archivo pathsGarantiasAval 1GA eliminado: " + itemToRemove);
                } else {
                    Log.d("MOD", "Archivo pathsGarantiasAval 1GA no encontrado");
                }
                break;

            case "2GA.jpeg":
                imgGarantia3A.setImageDrawable(null);
                imgGarantia3A.setVisibility(View.GONE);

                // Buscar y eliminar el archivo de pathsGarantiasAval
                for (String path : pathsGarantiasAval) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }

                if (itemToRemove != null) {
                    pathsGarantiasAval.remove(itemToRemove);
                    Log.d("MOD", "Archivo pathsGarantiasAval 2GA eliminado: " + itemToRemove);
                } else {
                    Log.d("MOD", "Archivo pathsGarantiasAval 2GA no encontrado");
                }
                break;

            case "3GA.jpeg":
                imgGarantia4A.setImageDrawable(null);
                imgGarantia4A.setVisibility(View.GONE);

                // Buscar y eliminar el archivo de pathsGarantiasAval
                for (String path : pathsGarantiasAval) {
                    if (path.contains(fileName)) {
                        itemToRemove = path;
                        break;
                    }
                }

                if (itemToRemove != null) {
                    pathsGarantiasAval.remove(itemToRemove);
                    Log.d("MOD", "Archivo pathsGarantiasAval 3GA eliminado: " + itemToRemove);
                } else {
                    Log.d("MOD", "Archivo pathsGarantiasAval 3GA no encontrado");
                }
                break;
        }
    }

    private final ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
    public interface OnPhotosSelectedListener {
        void onPhotosSelected(ArrayList<String> pathsComprobantesCliente,
                              ArrayList<String> pathsGarantiasCliente,
                              ArrayList<String> pathsIneCliente,
                              ArrayList<String> pathsFotoCliente,
                              ArrayList<String> pathsFachadaCliente,
                              ArrayList<String> pathsContratoCliente, List<MultipartBody.Part> archivosGeneral);
    }

    private Bitmap resizeBitmap(Bitmap bitmap, int maxSize) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float bitmapRatio = (float) width / (float) height;

        if (bitmapRatio > 1) {
            width = maxSize;
            height = (int) (width / bitmapRatio);
        } else {
            height = maxSize;
            width = (int) (height * bitmapRatio);
        }

        Bitmap resizedBitmap = Bitmap.createScaledBitmap(bitmap, width, height, true);
        addDateTimeToBitmap(resizedBitmap);
        addCoordsToBitmap(resizedBitmap);
        return resizedBitmap;
    }
    private File saveBitmapToFile(Bitmap bitmap) throws IOException {
        File file = File.createTempFile("compressed_image", ".jpeg");
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, fos);
        fos.flush();
        fos.close();
        return file;
    }
    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }

    private void addCoordsToBitmap(Bitmap bitmap) {
        getCurrentLocation("cliente");

        String text = lat + ", " + lgt;

        Canvas canvas = new Canvas(bitmap);

        Paint backgroundPaint = new Paint();

        Paint textPaint = new Paint();
        textPaint.setColor(Color.WHITE);
        textPaint.setTextSize(18);
        textPaint.setAntiAlias(true);

        float textWidth = textPaint.measureText(text);
        float textHeight = textPaint.getTextSize();

        float padding = 10;

        float x = bitmap.getWidth() - textWidth - padding;
        float y = bitmap.getHeight() - padding;

        canvas.drawRect(
                x - padding,
                y - textHeight - padding / 2,
                bitmap.getWidth(),
                bitmap.getHeight(),
                backgroundPaint
        );

        canvas.drawText(text, x, y, textPaint);
    }
    private void addDateTimeToBitmap(Bitmap bitmap) {
        String currentDateTime = getCurrentDateTime();

        Canvas canvas = new Canvas(bitmap);

        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor("#80000000"));
        canvas.drawRect(0, bitmap.getHeight() - 40, bitmap.getWidth(), bitmap.getHeight(), backgroundPaint);

        Paint textPaint = new Paint();
        textPaint.setColor(Color.WHITE); // Color del texto
        textPaint.setTextSize(18); // Tamaño del texto
        textPaint.setAntiAlias(true); // Suavizar el texto

        float x = 10;
        float y = bitmap.getHeight() - 15;

        canvas.drawText(currentDateTime, x, y, textPaint);
    }
    private void openCameraIntent() {
        ContentValues values = new ContentValues();

        values.put(MediaStore.Images.Media.TITLE, "Imagen ejemplo");
        values.put(MediaStore.Images.Media.DESCRIPTION, "Camara ejemplo");

        image_uri = getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);

        Intent i = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        i.putExtra(MediaStore.EXTRA_OUTPUT, image_uri);
        startActivityForResult(i, CODIGO_PERMISOS_CAMARA);
    }

    // Método para abrir la cámara usando Camera2 API
    private void openCamera() {
        try {
            if (!surfaceReady || surfaceHolder == null) {
                Log.e("SURFACE", "El surface no está listo o el SurfaceHolder es nulo.");
                return;
            }

            camera = Camera.open();  // Abre la cámara
            Camera.Parameters params = camera.getParameters();

            // Habilitar enfoque automático si está disponible
            if (params.getSupportedFocusModes().contains(Camera.Parameters.FOCUS_MODE_AUTO)) {
                params.setFocusMode(Camera.Parameters.FOCUS_MODE_AUTO);
            }
            camera.setParameters(params);

            try {
                camera.setPreviewDisplay(surfaceHolder); // Usa la variable global surfaceHolder
                camera.startPreview(); // Inicia la vista previa
            } catch (IOException e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveImage(Bitmap croppedImage, Button btnTakePhoto) {
        // Crear un objeto ContentValues para almacenar los metadatos de la imagen
        ContentValues values = new ContentValues();
        values.put(MediaStore.Images.Media.TITLE, "Imagen ejemplo");
        values.put(MediaStore.Images.Media.DESCRIPTION, "Camara ejemplo");

        // Insertar la imagen en el MediaStore para que se pueda guardar en la galería
        image_uri = getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        Log.e("saveImage", "Ruta de la imagen image_uri: " + image_uri);

        // Abre un OutputStream para escribir la imagen en el almacenamiento
        try (OutputStream outputStream = getContext().getContentResolver().openOutputStream(image_uri)) {
            if (outputStream != null) {
                // Comprime y guarda la imagen en el OutputStream en formato JPEG
                boolean isCompressed = croppedImage.compress(Bitmap.CompressFormat.JPEG, 100, outputStream);
                if (isCompressed) {
                    if (camaraIneClienteAbierta) {
                        int indexToStartIne = 0;
                        Log.d("saveImage", "Imagen guardada correctamente en: " + image_uri);

                        // Obtener el path desde la URI
                        path = image_uri.toString();
                        pathsIneCliente.add(path);

                        // Redimensionar la imagen si es necesario (opcional, dependiendo de cómo lo quieras manejar)
                        Bitmap reduceBitmap = resizeBitmap(croppedImage, 1400);

                        // Guardar la imagen redimensionada en un archivo comprimido
                        File compressedFile = saveBitmapToFile(reduceBitmap);

                        // Verifica el índice que falta y carga el archivo correspondiente
                        int missingIndexIne = findMissingIndexIne();
                        if (missingIndexIne != -1) {
                            // Cambiar el nombre del archivo comprimido para que tenga el sufijo correcto
                            File renamedFile = new File(compressedFile.getParent(), missingIndexIne + "CC.jpeg");
                            if (compressedFile.renameTo(renamedFile)) {
                                pathsIneCliente.add(renamedFile.getAbsolutePath());
                                pathsIneCliente2.add(renamedFile.getAbsolutePath());

                                // Preparar para el envío del archivo
                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + missingIndexIne, renamedFile.getName(), requestFile);
                                archivosGeneral.add(body);
                                btnTakePhoto.setEnabled(true);
                                // Mostrar la imagen en el cuadro correspondiente
                                getActivity().runOnUiThread(() -> {
                                    if (missingIndexIne == 0) { // INE Frente
                                        imgIneFrente.setImageBitmap(reduceBitmap);
                                        imgIneFrente.setVisibility(View.VISIBLE);
                                    } else if (missingIndexIne == 1) { // INE Reverso
                                        imgIneReverso.setImageBitmap(reduceBitmap);
                                        imgIneReverso.setVisibility(View.VISIBLE);
                                    }
                                });
                                Toast.makeText(getActivity(), "Foto capturada correctamente", Toast.LENGTH_LONG).show();
                            }
                            Log.d("MOD", "Archivo " + missingIndexIne + " agregado: " + renamedFile.getAbsolutePath());
                        } else {
                            // Si no falta ningún archivo, procesa el primer archivo
                            pathsIneCliente.clear();
                            File renamedFile = new File(compressedFile.getParent(), indexToStartIne + "CC.jpeg");
                            if (compressedFile.renameTo(renamedFile)) {
                                pathsIneCliente.add(renamedFile.getAbsolutePath());
                                pathsIneCliente2.add(renamedFile.getAbsolutePath());

                                // Subir el archivo con el índice 0
                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + indexToStartIne, renamedFile.getName(), requestFile);
                                archivosGeneral.add(body);
                                btnTakePhoto.setEnabled(true);
                                // Mostrar la imagen de la UI para el índice 0
                                getActivity().runOnUiThread(() -> {
                                    imgIneFrente.setImageBitmap(reduceBitmap);
                                    imgIneFrente.setVisibility(View.VISIBLE);
                                });
                                Toast.makeText(getActivity(), "Foto capturada correctamente", Toast.LENGTH_LONG).show();
                                Log.d("MOD", "Archivo 0 agregado: " + renamedFile.getAbsolutePath());
                            } else {
                                btnTakePhoto.setEnabled(true);
                                Log.e("ERROR", "No se pudo renombrar el archivo comprimido para el índice 0.");
                                Toast.makeText(getActivity(), "ERROR AL CAPTURAR LA FOTO, INTENTELO DE NUEVO", Toast.LENGTH_LONG).show();
                            }
                            Log.e("INFO", "No falta ningún archivo. Empezando desde el índice 0.");
                        }
                    }
                    if (camaraContratoClienteAbierta) {
                        Log.d("saveImage", "Imagen guardada correctamente en: " + image_uri);
                        int indexToStartContrato = 3;
                        // Obtener el path desde la URI
                        path = image_uri.toString();
                        pathsContratoCliente.add(path);

                        // Redimensionar la imagen si es necesario (opcional, dependiendo de cómo lo quieras manejar)
                        Bitmap reduceBitmap = resizeBitmap(croppedImage, 1400);

                        // Guardar la imagen redimensionada en un archivo comprimido
                        File compressedFile = saveBitmapToFile(reduceBitmap);

                        // Verifica el índice que falta y carga el archivo correspondiente
                        int missingIndexContrato = findMissingIndexContrato();
                        if (missingIndexContrato != -1) {
                            // Cambiar el nombre del archivo comprimido para que tenga el sufijo correcto
                            File renamedFile = new File(compressedFile.getParent(), missingIndexContrato + "CC.jpeg");
                            if (compressedFile.renameTo(renamedFile)) {
                                pathsContratoCliente.add(renamedFile.getAbsolutePath());
                                pathsContratoCliente2.add(renamedFile.getAbsolutePath());

                                // Subir el archivo usando el archivo renombrado
                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + missingIndexContrato, renamedFile.getName(), requestFile);
                                archivosGeneral.add(body);
                                btnTakePhoto.setEnabled(true);
                                getActivity().runOnUiThread(() -> {
                                    // Mostrar la imagen en el cuadro correspondiente
                                    if (missingIndexContrato == 3) {
                                        imgContratoFrente.setImageBitmap(reduceBitmap);
                                        imgContratoFrente.setVisibility(View.VISIBLE);
                                    } else if (missingIndexContrato == 4) {
                                        imgContratoReverso.setImageBitmap(reduceBitmap);
                                        imgContratoReverso.setVisibility(View.VISIBLE);
                                    }
                                });
                                Toast.makeText(getActivity(), "Foto capturada correctamente", Toast.LENGTH_LONG).show();
                                Log.d("MOD", "Archivo " + missingIndexContrato + " agregado: " + renamedFile.getAbsolutePath());
                            }
                        } else {
                            // Si no falta ningún archivo, procesa el primer archivo
                            pathsContratoCliente.clear();
                            File renamedFile = new File(compressedFile.getParent(), indexToStartContrato + "CC.jpeg");
                            if (compressedFile.renameTo(renamedFile)) {
                                pathsContratoCliente.add(renamedFile.getAbsolutePath());
                                pathsContratoCliente2.add(renamedFile.getAbsolutePath());

                                // Subir el archivo con el índice 0
                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + indexToStartContrato, renamedFile.getName(), requestFile);
                                archivosGeneral.add(body);
                                btnTakePhoto.setEnabled(true);
                                // Mostrar la imagen de la UI para el índice 0
                                getActivity().runOnUiThread(() -> {
                                    // Mostrar la imagen para el índice 0
                                    if (indexToStartContrato == 3) {
                                        imgContratoFrente.setImageBitmap(reduceBitmap);
                                        imgContratoFrente.setVisibility(View.VISIBLE);
                                    } else if (indexToStartContrato == 4) {
                                        imgContratoReverso.setImageBitmap(reduceBitmap);
                                        imgContratoReverso.setVisibility(View.VISIBLE);
                                    }
                                });
                                Toast.makeText(getActivity(), "Foto capturada correctamente", Toast.LENGTH_LONG).show();
                                Log.d("MOD", "Archivo 0 agregado: " + renamedFile.getAbsolutePath());
                            } else {
                                Toast.makeText(getActivity(), "ERROR AL CAPTURAR LA FOTO, INTENTELO DE NUEVO", Toast.LENGTH_LONG).show();
                                btnTakePhoto.setEnabled(true);
                            }
                            Log.e("INFO", "No falta ningún archivo. Empezando desde el índice 0.");
                        }
                    }
                    if (camaraComprobantesClienteAbierta) {
                        int indexToStartCC = 2;
                        path = RealPathUtil.getRealPath(getActivity(), image_uri);
                        if (path != null) {
                            Bitmap bitmap = BitmapFactory.decodeFile(path);
                            pathsComprobantesCliente.add(path);
                            pathsComprobantesCliente2.add(path);
                            Bitmap fullBitmap = BitmapFactory.decodeFile(path);
                            Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                            File compressedFile = null;

                            compressedFile = saveBitmapToFile(reduceBitmap);

                            RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                            MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + indexToStartCC, "2CC.jpeg", requestFile);

                            archivosGeneral.add(body);

                            getActivity().runOnUiThread(() -> {
                                imgComprobante.setImageBitmap(reduceBitmap);
                                imgComprobante.setVisibility(View.VISIBLE);
                            });
                            Toast.makeText(getActivity(), "Foto capturada correctamente", Toast.LENGTH_LONG).show();
                        }
                    }
                    if (camaraIneAvalAbierta) {
                        int indexToStartIne = 0;
                        Log.d("saveImage", "Imagen guardada correctamente en: " + image_uri);

                        // Obtener el path desde la URI
                        path = image_uri.toString();
                        pathsIneAval.add(path);

                        // Redimensionar la imagen si es necesario (opcional, dependiendo de cómo lo quieras manejar)
                        Bitmap reduceBitmap = resizeBitmap(croppedImage, 1400);

                        // Guardar la imagen redimensionada en un archivo comprimido
                        File compressedFile = saveBitmapToFile(reduceBitmap);

                        // Verifica el índice que falta y carga el archivo correspondiente
                        int missingIndexIne = findMissingIndexIneA();
                        if (missingIndexIne != -1) {
                            // Cambiar el nombre del archivo comprimido para que tenga el sufijo correcto
                            File renamedFile = new File(compressedFile.getParent(), missingIndexIne + "CA.jpeg");
                            if (compressedFile.renameTo(renamedFile)) {
                                pathsIneAval.add(renamedFile.getAbsolutePath());
                                pathsIneAval2.add(renamedFile.getAbsolutePath());

                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + missingIndexIne, renamedFile.getName(), requestFile);
                                archivosGeneral.add(body);
                                btnTakePhoto.setEnabled(true);
                                // Mostrar la imagen en el cuadro correspondiente

                                if (missingIndexIne == 0) { // INE Frente
                                    imgIneFrenteA.setImageBitmap(reduceBitmap);
                                    imgIneFrenteA.setVisibility(View.VISIBLE);
                                } else if (missingIndexIne == 1) { // INE Reverso
                                    imgIneReversoA.setImageBitmap(reduceBitmap);
                                    imgIneReversoA.setVisibility(View.VISIBLE);
                                }
                                Toast.makeText(getActivity(), "Foto capturada correctamente", Toast.LENGTH_LONG).show();
                            }
                            Log.d("MOD", "Archivo " + missingIndexIne + " agregado: " + renamedFile.getAbsolutePath());
                        } else {
                            // Si no falta ningún archivo, procesa el primer archivo
                            pathsIneAval.clear();

                            File renamedFile = new File(compressedFile.getParent(), indexToStartIne + "CA.jpeg");
                            if (compressedFile.renameTo(renamedFile)) {
                                pathsIneAval.add(renamedFile.getAbsolutePath());
                                pathsIneAval2.add(renamedFile.getAbsolutePath());

                                // Subir el archivo con el índice 0
                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + indexToStartIne, renamedFile.getName(), requestFile);
                                archivosGeneral.add(body);
                                btnTakePhoto.setEnabled(true);
                                // Mostrar la imagen de la UI para el índice 0
                                getActivity().runOnUiThread(() -> {
                                    imgIneFrenteA.setImageBitmap(reduceBitmap);
                                    imgIneFrenteA.setVisibility(View.VISIBLE);
                                });
                                Toast.makeText(getActivity(), "Foto capturada correctamente", Toast.LENGTH_LONG).show();
                                Log.d("MOD", "Archivo 0 agregado: " + renamedFile.getAbsolutePath());
                            } else {
                                Toast.makeText(getActivity(), "ERROR AL CAPTURAR LA FOTO, INTENTELO DE NUEVO", Toast.LENGTH_LONG).show();
                                btnTakePhoto.setEnabled(true);
                            }
                            Log.e("INFO", "No falta ningún archivo. Empezando desde el índice 0.");
                        }
                    }
                    if (camaraComprobantesAvalAbierta) {
                        int indexToStartCC = 2;
                        path = image_uri.toString();
                        // Redimensionar la imagen si es necesario (opcional, dependiendo de cómo lo quieras manejar)
                        Bitmap reduceBitmap = resizeBitmap(croppedImage, 1400);

                        // Guardar la imagen redimensionada en un archivo comprimido
                        File compressedFile = saveBitmapToFile(reduceBitmap);
                        pathsComprobantesAval.add(path);
                        pathsComprobantesAval2.add(path);
                        RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                        MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + indexToStartCC, "2CA.jpeg", requestFile);
                        archivosGeneral.add(body);

                        imgComprobanteA.setImageBitmap(reduceBitmap);
                        imgComprobanteA.setVisibility(View.VISIBLE);

                        Toast.makeText(getActivity(), "Foto capturada correctamente", Toast.LENGTH_LONG).show();
                    }

                }
            }
        } catch (IOException e) {
            e.printStackTrace();
            Log.e("saveImage", "Error al guardar la imagen: " + e.getMessage());
            btnTakePhoto.setEnabled(true);
        }
    }

    private void takePicture(SurfaceView surfaceView, Button btnTakePhoto, View overlayRect) {
        if (camera != null) {
            try {
                // Detener la vista previa antes de capturar la imagen
                //camera.stopPreview();
                //Log.d("Camera", "Vista previa detenida");

                // Tomar la foto
                camera.takePicture(null, null, (data, camera) -> {
                    Log.d("Camera", "Toma de foto iniciada");

                    // Procesar la imagen capturada
                    Bitmap capturedImage = BitmapFactory.decodeByteArray(data, 0, data.length);
                    if (camaraComprobantesClienteAbierta || camaraComprobantesAvalAbierta) {
                        // Asegurarse de que la cámara esté en modo vertical (90 grados)
                        Matrix matrix = new Matrix();
                        matrix.postRotate(90);  // Rotar la imagen 90 grados
                        capturedImage = Bitmap.createBitmap(capturedImage, 0, 0, capturedImage.getWidth(), capturedImage.getHeight(), matrix, true);
                    }
                    if (capturedImage != null) {
                        processImage(capturedImage, surfaceView, btnTakePhoto, overlayRect);  // Procesar la imagen
                        Log.d("Camera", "Imagen procesada");
                    }

                    // Reiniciar la vista previa después de tomar la foto
                    try {
                        camera.startPreview();  // Reiniciar la vista previa
                        Log.d("Camera", "Vista previa reiniciada");
                    } catch (Exception e) {
                        e.printStackTrace();
                        Log.e("Camera", "Error al reiniciar la vista previa: " + e.getMessage());
                    }

                    // Habilitar el botón nuevamente
                    btnTakePhoto.setEnabled(true);
                });
            } catch (RuntimeException e) {
                e.printStackTrace();
                Log.e("CameraError", "Error al tomar la foto: " + e.getMessage());
            }
        } else {
            Log.e("Camera", "La cámara no está inicializada.");
        }
    }

    private void processImage(Bitmap capturedImage, SurfaceView surfaceView, Button btnTakePhoto, View overlayRect) {
        // Aquí puedes procesar la imagen como antes, por ejemplo recortando según el rectángulo
        Rect rect = new Rect();
        overlayRect.getGlobalVisibleRect(rect);

        float scaleX = (float) capturedImage.getWidth() / surfaceView.getWidth();
        float scaleY = (float) capturedImage.getHeight() / surfaceView.getHeight();

        int x = (int) (rect.left * scaleX);
        int y = (int) (rect.top * scaleY);
        int width = (int) (rect.width() * scaleX);
        int height = (int) (rect.height() * scaleY);

        x = Math.max(0, x);
        y = Math.max(0, y);
        width = Math.min(width, capturedImage.getWidth() - x);
        height = Math.min(height, capturedImage.getHeight() - y);

        Bitmap croppedImage = Bitmap.createBitmap(capturedImage, x, y, width, height);
        saveImage(croppedImage, btnTakePhoto); // Guardar la imagen recortada
    }

    private Camera camera;

    // Variable miembro de la clase para almacenar el SurfaceView
    private SurfaceView surfaceView;

    private Handler focusHandler = new Handler();
    private Runnable focusRunnable = new Runnable() {
        @Override
        public void run() {
            // Verifica que el SurfaceView y la cámara estén disponibles
            if (surfaceView != null && surfaceView.getWidth() > 0 && surfaceView.getHeight() > 0 && camera != null) {
                // Obtener las coordenadas del centro de la pantalla
                float centerX = surfaceView.getWidth() / 2;
                float centerY = surfaceView.getHeight() / 2;

                // Llamar a la función para simular el enfoque en el centro
                simulateFocus(centerX, centerY);
            }

            // Reprogramar el Runnable para ejecutarse cada 2 segundos
            focusHandler.postDelayed(this, 2000);
        }
    };

    private void simulateFocus(float x, float y) {
        // Verifica que la cámara esté activa antes de proceder
        if (camera != null) {
            Camera.Parameters params = camera.getParameters();
            List<Camera.Area> focusAreas = new ArrayList<>();
            Rect focusRect = calculateFocusArea(x, y);  // Calcula el área de enfoque en el punto dado
            focusAreas.add(new Camera.Area(focusRect, 1000));  // Enfoque fuerte (valor entre 0 y 1000)
            params.setFocusAreas(focusAreas);

            // Si la cámara soporta enfoque automático, se activa
            if (params.getSupportedFocusModes().contains(Camera.Parameters.FOCUS_MODE_AUTO)) {
                params.setFocusMode(Camera.Parameters.FOCUS_MODE_AUTO);
                camera.setParameters(params);

                // Asegúrate de que la cámara esté en el estado correcto para el enfoque
                camera.autoFocus((success, camera1) -> {
                    if (success) {
                        Log.d("Camera", "Enfoque automático exitoso.");
                    } else {
                        Log.d("Camera", "Enfoque automático fallido.");
                    }
                });
            } else {
                Log.d("Camera", "La cámara no soporta enfoque automático.");
            }
        }
    }

    private void openCameraModal() {
        // Crear un diálogo de pantalla completa
        Dialog cameraDialog = new Dialog(getContext());

        // Establecer el layout del diálogo
        cameraDialog.setContentView(R.layout.camera_layout);

        // Obtener el tamaño de la pantalla
        Display display = getActivity().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        // Calcular el 80% del alto de la pantalla
        int screenHeight = size.y;
        int dialogHeight = (int) (screenHeight * 0.99); // 99% de la altura de la pantalla

        // Configura el estilo de ventana
        cameraDialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, dialogHeight);
        cameraDialog.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);

        // Configura el SurfaceView dentro del diálogo y lo guarda en la variable miembro
        surfaceView = cameraDialog.findViewById(R.id.surfaceView);

        // Configura la superposición transparente con un hueco
        View transparentOverlay = cameraDialog.findViewById(R.id.transparentOverlay);
        View overlayRect = cameraDialog.findViewById(R.id.overlayRect);

        // Observa los cambios de layout para calcular el hueco correctamente
        overlayRect.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                overlayRect.getViewTreeObserver().removeOnGlobalLayoutListener(this);

                int left = overlayRect.getLeft();
                int top = overlayRect.getTop();
                int right = overlayRect.getRight();
                int bottom = overlayRect.getBottom();

                transparentOverlay.setBackground(new Drawable() {
                    @Override
                    public void draw(@NonNull Canvas canvas) {
                        Paint paint = new Paint();
                        paint.setColor(0xFFFF8C00); // Naranja oscuro
                        paint.setStyle(Paint.Style.FILL);
                        paint.setAntiAlias(true);

                        canvas.drawRect(0, 0, getBounds().width(), getBounds().height(), paint);
                        paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
                        canvas.drawRect(left, top, right, bottom, paint);
                    }

                    @Override
                    public void setAlpha(int alpha) {}

                    @Override
                    public void setColorFilter(@Nullable ColorFilter colorFilter) {}

                    @Override
                    public int getOpacity() {
                        return PixelFormat.TRANSLUCENT;
                    }
                });
            }
        });

        // Configura el botón para cerrar la cámara
        Button btnCloseCamera = cameraDialog.findViewById(R.id.btnCloseCamera);
        btnCloseCamera.setOnClickListener(v -> {
            surfaceReady = false;
            if (camera != null) {
                camera.stopPreview();
                camera.release();
                camera = null;
            }
            cameraDialog.dismiss();
        });

        // Botón para tomar foto
        Button btnTakePhoto = cameraDialog.findViewById(R.id.btnTakePhoto);
        btnTakePhoto.setOnClickListener(v -> {
            if (camera != null) {
                btnTakePhoto.setEnabled(false);
                takePicture(surfaceView, btnTakePhoto, overlayRect);
            }
        });

        // Configura el SurfaceHolder para la preview de la cámara
        SurfaceHolder holder = surfaceView.getHolder();
        holder.addCallback(new SurfaceHolder.Callback() {
            @SuppressLint("ClickableViewAccessibility")
            @Override
            public void surfaceCreated(SurfaceHolder holder) {
                surfaceHolder = holder;
                surfaceReady = true;
                openCamera();

                if (DeviceUtils.isMIUI()) {
                    camera.setDisplayOrientation(90);
                } else {
                    camera.setDisplayOrientation(90);
                }

                // Iniciar el enfoque automático cada 2 segundos
                focusHandler.post(focusRunnable);
            }

            @Override
            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                surfaceHolder = holder;
            }

            @Override
            public void surfaceDestroyed(SurfaceHolder holder) {
                surfaceReady = false;
                if (camera != null) {
                    camera.stopPreview();
                    camera.release();
                    camera = null;
                }

                // Detener el enfoque automático
                focusHandler.removeCallbacks(focusRunnable);
            }
        });

        // Mostrar el diálogo
        cameraDialog.show();
    }

    private Rect calculateFocusArea(float x, float y) {
        // Definir el tamaño del área de enfoque en píxeles
        int areaSize = 200; // El tamaño de la zona de enfoque (ajustable según tus necesidades)

        // Convertir las coordenadas tocadas a una zona en la cámara
        int left = clamp((int) (x - areaSize / 2), 0, 1000);
        int top = clamp((int) (y - areaSize / 2), 0, 1000);
        int right = clamp((int) (x + areaSize / 2), 0, 1000);
        int bottom = clamp((int) (y + areaSize / 2), 0, 1000);

        // Devolver el área de enfoque calculada
        return new Rect(left, top, right, bottom);
    }

    private int clamp(int x, int min, int max) {
        return Math.max(min, Math.min(x, max));
    }

    // Método para configurar la vista previa de la cámara
    private void createCameraPreviewSession() {
        try {
            if (!surfaceReady || surface == null || cameraDevice == null) {
                throw new IllegalStateException("Surface or CameraDevice is not ready!");
            }

            CaptureRequest.Builder builder = cameraDevice.createCaptureRequest(CameraDevice.TEMPLATE_PREVIEW);
            builder.addTarget(surface);

            cameraDevice.createCaptureSession(Collections.singletonList(surface),
                    new CameraCaptureSession.StateCallback() {
                        @Override
                        public void onConfigured(@NonNull CameraCaptureSession session) {
                            try {
                                session.setRepeatingRequest(builder.build(), null, null);
                            } catch (CameraAccessException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onConfigureFailed(@NonNull CameraCaptureSession session) {
                            // Maneja la configuración fallida
                        }
                    }, null
            );
        } catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void openGalleryIntent() {
        Intent pickPhotoIntent = new Intent(Intent.ACTION_GET_CONTENT);
        pickPhotoIntent.setType("image/*");
        pickPhotoIntent.putExtra(Intent.EXTRA_ALLOW_MULTIPLE, true);
        startActivityForResult(Intent.createChooser(pickPhotoIntent, "Selecciona imágenes"), CODIGO_PERMISOS_CAMARA);
    }
    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1) {
            if (resultCode == Activity.RESULT_OK) {
                if (camaraGarantiasClienteAbierta) {
                    int indexToStart = 0;
                    if (data != null) {
                        ClipData clipData = data.getClipData();
                        if (clipData != null) {
                            List<Uri> urisToUpload = new ArrayList<>();

                            for (int i = 0; i < clipData.getItemCount(); i++) {
                                uri = clipData.getItemAt(i).getUri();
                                if (uri != null) {
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        urisToUpload.add(uri); // Guarda el URI para más adelante
                                    }
                                }
                            }

                            for (int i = 0; i < urisToUpload.size(); i++) {
                                uri = urisToUpload.get(i);


                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        Bitmap bitmap = BitmapFactory.decodeFile(path);
                                        Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                        File compressedFile = null;
                                        try {
                                            compressedFile = saveBitmapToFile(reduceBitmap);
                                        } catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }

                                        if (compressedFile != null) {
                                            int assignedIndex = findMissingIndex();
                                            if (assignedIndex != -1) {
                                                File renamedFile = new File(compressedFile.getParent(), assignedIndex + "GC.jpeg");
                                                if (compressedFile.renameTo(renamedFile)) {
                                                    // El archivo ha sido renombrado correctamente
                                                    Log.d("Archivo", "Archivo renombrado a: " + renamedFile.getAbsolutePath());

                                                    pathsGarantiasCliente.add(renamedFile.getAbsolutePath());
                                                    pathsGarantiasCliente2.add(renamedFile.getAbsolutePath());
                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_cliente_" + assignedIndex, renamedFile.getName(), requestFile);
                                                    archivosGeneral.add(body);
                                                    getActivity().runOnUiThread(() -> {
                                                        displayImage(reduceBitmap, assignedIndex); // Mostrar la imagen en la UI
                                                        Log.d("MOD", "Archivo " + assignedIndex + " agregado: " + renamedFile.getAbsolutePath());
                                                    });
                                                } else {
                                                    Log.e("ERROR", "No se pudo renombrar el archivo comprimido.");
                                                }
                                            }else {
                                                pathsGarantiasCliente.clear();

                                                // Aquí generas y subes el archivo para el índice 0 (como si fuera el primero)
                                                File renamedFile2 = new File(compressedFile.getParent(), indexToStart + "GC.jpeg");
                                                if (compressedFile.renameTo(renamedFile2)) {
                                                    Log.d("Archivo", "Archivo renombrado a: " + renamedFile2.getAbsolutePath());

                                                    pathsGarantiasCliente.add(renamedFile2.getAbsolutePath());
                                                    pathsGarantiasCliente2.add(renamedFile2.getAbsolutePath());

                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile2);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_cliente_" + indexToStart, renamedFile2.getName(), requestFile);
                                                    archivosGeneral.add(body);
                                                    getActivity().runOnUiThread(() -> {
                                                        displayImage(reduceBitmap, indexToStart); // Mostrar la imagen en la UI
                                                    });
                                                }
                                            }
                                        }
                                    }
                            }

                        } else {
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        Bitmap bitmap = BitmapFactory.decodeFile(path);
                                        pathsGarantiasCliente.add(path);
                                        pathsGarantiasCliente2.add(path);
                                        Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                        File compressedFile = null;
                                        try {
                                            compressedFile = saveBitmapToFile(reduceBitmap);
                                        } catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }

                                        int missingIndex = findMissingIndex();
                                        if (missingIndex != -1) {
                                            File renamedFile = new File(compressedFile.getParent(), missingIndex + "GC.jpeg");
                                            if (compressedFile.renameTo(renamedFile)) {
                                                pathsGarantiasCliente.add(renamedFile.getAbsolutePath());
                                                pathsGarantiasCliente2.add(renamedFile.getAbsolutePath());
                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_cliente_" + missingIndex, renamedFile.getName(), requestFile);
                                                archivosGeneral.add(body);
                                                getActivity().runOnUiThread(() -> {
                                                    displayImage(reduceBitmap, missingIndex); // Mostrar la imagen en la UI
                                                });
                                            }
                                        }else {
                                            pathsGarantiasCliente.clear();

                                            // Aquí generas y subes el archivo para el índice 0 (como si fuera el primero)
                                            File renamedFile2 = new File(compressedFile.getParent(), indexToStart + "GC.jpeg");
                                            if (compressedFile.renameTo(renamedFile2)) {
                                                Log.d("Archivo", "Archivo renombrado a: " + renamedFile2.getAbsolutePath());

                                                pathsGarantiasCliente.add(renamedFile2.getAbsolutePath());
                                                pathsGarantiasCliente2.add(renamedFile2.getAbsolutePath());

                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile2);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_cliente_" + indexToStart, renamedFile2.getName(), requestFile);
                                                archivosGeneral.add(body);
                                                getActivity().runOnUiThread(() -> {
                                                    displayImage(reduceBitmap, indexToStart); // Mostrar la imagen en la UI
                                                });
                                            }
                                        }
                                    }
                            }
                        }
                    } else {
                    path = RealPathUtil.getRealPath(getActivity(), image_uri);
                        if (path != null) {
                            Bitmap bitmap = BitmapFactory.decodeFile(path);
                            pathsGarantiasCliente.add(path);
                            pathsGarantiasCliente2.add(path);
                            Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                            File compressedFile = null;
                            try {
                                compressedFile = saveBitmapToFile(reduceBitmap);
                            } catch (IOException e) {
                                throw new RuntimeException(e);
                            }

                            int missingIndex = findMissingIndex();
                            if (missingIndex != -1) {
                                File renamedFile = new File(compressedFile.getParent(), missingIndex + "GC.jpeg");
                                if (compressedFile.renameTo(renamedFile)) {
                                    pathsGarantiasCliente.add(renamedFile.getAbsolutePath());
                                    pathsGarantiasCliente2.add(renamedFile.getAbsolutePath());
                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                    MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_cliente_" + missingIndex, renamedFile.getName(), requestFile);
                                    archivosGeneral.add(body);
                                    getActivity().runOnUiThread(() -> {
                                        displayImage(reduceBitmap, missingIndex); // Mostrar la imagen en la UI
                                    });
                                }
                            } else {
                                pathsGarantiasCliente.clear();
                                // Si no falta ningún índice, empezar desde el índice 0
                                Log.d("log", "No falta ningún archivo. Empezando desde el índice 0.");

                                // Aquí generas y subes el archivo para el índice 0 (como si fuera el primero)
                                File renamedFile2 = new File(compressedFile.getParent(), indexToStart + "GC.jpeg");
                                if (compressedFile.renameTo(renamedFile2)) {
                                    pathsGarantiasCliente.add(renamedFile2.getAbsolutePath());
                                    pathsGarantiasCliente2.add(renamedFile2.getAbsolutePath());
                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile2);
                                    MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_cliente_" + indexToStart, renamedFile2.getName(), requestFile);
                                    archivosGeneral.add(body);
                                    getActivity().runOnUiThread(() -> {
                                        displayImage(reduceBitmap, indexToStart); // Mostrar la imagen en la UI
                                    });
                                }
                            }
                        }
                    }
                }

                if (camaraGarantiasRetiradas) {
                    if (data != null) {
                        ClipData clipData = data.getClipData();
                        if (clipData != null) {
                            for (int i = 0; i < clipData.getItemCount(); i++) {
                                uri = clipData.getItemAt(i).getUri();
                                if (uri != null) {
                                    int index = i;
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                        if (path != null) {
                                            Bitmap bitmap = BitmapFactory.decodeFile(path);
                                            pathsGarantiasRetiradas.add(path);

                                            Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                            File compressedFile = null;
                                            try {
                                                compressedFile = saveBitmapToFile(reduceBitmap);
                                            } catch (IOException e) {
                                                throw new RuntimeException(e);
                                            }

                                            RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                            MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_retirada_" + index, index + "GA.jpeg", requestFile);
                                            archivosGeneral.add(body);
                                        }
                                }
                            }
                        } else {
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        Bitmap bitmap = BitmapFactory.decodeFile(path);
                                        pathsGarantiasRetiradas.add(path);

                                        Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                        File compressedFile = null;
                                        try {
                                            compressedFile = saveBitmapToFile(reduceBitmap);
                                        } catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }

                                        RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                        MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_retirada_0", "0GA.jpeg", requestFile);
                                        archivosGeneral.add(body);
                                    }
                            }
                        }
                    } else {
                        path = RealPathUtil.getRealPath(getActivity(), image_uri);
                            if (path != null) {
                                Bitmap bitmap = BitmapFactory.decodeFile(path);
                                pathsGarantiasRetiradas.add(path);

                                Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                File compressedFile = null;
                                try {
                                    compressedFile = saveBitmapToFile(reduceBitmap);
                                } catch (IOException e) {
                                    throw new RuntimeException(e);
                                }

                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_retirada_0", "0GA.jpeg", requestFile);
                                archivosGeneral.add(body);
                            }
                    }
                    btnCamGarantiasRetiradas.setText("Garantías (" + pathsGarantiasRetiradas.size() + ")");
                }
                if (camaraComprobantesClienteAbierta) {
                    int indexToStartContrato = 2;
                    if (data != null) {
                        Log.d("MOD", "archivo seleccion de imagen 1.");
                        ClipData clipData2 = data.getClipData();
                        if (clipData2 != null) {
                            // Proceso para múltiples imágenes
                            List<Uri> urisToUpload2 = new ArrayList<>();

                            for (int i = 0; i < clipData2.getItemCount(); i++) {
                                uri = clipData2.getItemAt(i).getUri();
                                if (uri != null) {
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        urisToUpload2.add(uri); // Guarda el URI para más adelante
                                    }
                                }
                            }

                            // Procesar cada URI y asignar el índice correspondiente
                            for (int i = 0; i < urisToUpload2.size(); i++) {
                                uri = urisToUpload2.get(i);
                                int index = i;
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                if (path != null) {
                                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                                    Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                    File compressedFile = null;
                                    try {
                                        compressedFile = saveBitmapToFile(reduceBitmap);
                                    } catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }

                                    if (compressedFile != null) {
                                        int assignedIndex = findMissingIndexContrato();
                                        if (assignedIndex != -1) {
                                            // Renombrar el archivo comprimido con el sufijo correcto
                                            File renamedFile = new File(compressedFile.getParent(), assignedIndex + "CC.jpeg");
                                            if (compressedFile.renameTo(renamedFile)) {
                                                Log.d("Archivo", "Archivo renombrado a: " + renamedFile.getAbsolutePath());

                                                // Añadir solo el archivo renombrado a la lista de paths
                                                pathsComprobantesCliente.add(renamedFile.getAbsolutePath());
                                                pathsComprobantesCliente2.add(renamedFile.getAbsolutePath());

                                                // Subir el archivo usando el archivo renombrado
                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + assignedIndex, renamedFile.getName(), requestFile);
                                                archivosGeneral.add(body);

                                                getActivity().runOnUiThread(() -> {
                                                    imgComprobante.setImageBitmap(reduceBitmap);
                                                    imgComprobante.setVisibility(View.VISIBLE);
                                                });
                                                Log.d("MOD", "Archivo " + assignedIndex + " agregado: " + renamedFile.getAbsolutePath());
                                            }
                                        }
                                        else
                                        {
                                            pathsComprobantesCliente.clear();

                                            File renamedFile = new File(compressedFile.getParent(), indexToStartContrato + "CC.jpeg");
                                            if (compressedFile.renameTo(renamedFile)) {
                                                pathsComprobantesCliente.add(renamedFile.getAbsolutePath());
                                                pathsComprobantesCliente2.add(renamedFile.getAbsolutePath());

                                                // Subir el archivo para el índice 0
                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + indexToStartContrato, renamedFile.getName(), requestFile);
                                                archivosGeneral.add(body);

                                                getActivity().runOnUiThread(() -> {
                                                    imgComprobante.setImageBitmap(reduceBitmap);
                                                    imgComprobante.setVisibility(View.VISIBLE);
                                                });
                                            }
                                            Log.d("log", "No falta ningún archivo. Empezando desde el índice 3.");
                                        }
                                    }
                                }
                            }
                        } else {
                            // Proceso para una sola imagen
                            Log.e("INFO", "Procesando una sola imagen.");
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                if (path != null) {
                                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                                    Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                    File compressedFile = null;
                                    try {
                                        compressedFile = saveBitmapToFile(reduceBitmap);
                                    } catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }

                                    if (compressedFile != null) {
                                        // Verificar el índice que falta
                                        int missingIndexIne = findMissingIndexContrato();
                                        if (missingIndexIne != -1) {
                                            // Renombrar el archivo comprimido con el sufijo correcto
                                            File renamedFile = new File(compressedFile.getParent(), missingIndexIne + "CC.jpeg");
                                            if (compressedFile.renameTo(renamedFile)) {
                                                Log.d("Archivo", "Archivo renombrado a: " + renamedFile.getAbsolutePath());

                                                pathsComprobantesCliente.add(renamedFile.getAbsolutePath());
                                                pathsComprobantesCliente2.add(renamedFile.getAbsolutePath());

                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + missingIndexIne, renamedFile.getName(), requestFile);
                                                archivosGeneral.add(body);

                                                getActivity().runOnUiThread(() -> {
                                                    imgComprobante.setImageBitmap(reduceBitmap);
                                                    imgComprobante.setVisibility(View.VISIBLE);
                                                });

                                                Log.d("MOD", "Archivo " + missingIndexIne + " agregado: " + renamedFile.getAbsolutePath());
                                            } else {
                                                Log.e("ERROR", "No se pudo renombrar el archivo comprimido.");
                                            }
                                        } else
                                        {
                                            pathsComprobantesCliente.clear();

                                            File renamedFile = new File(compressedFile.getParent(), indexToStartContrato + "CC.jpeg");
                                            if (compressedFile.renameTo(renamedFile)) {
                                                pathsComprobantesCliente.add(renamedFile.getAbsolutePath());
                                                pathsComprobantesCliente2.add(renamedFile.getAbsolutePath());

                                                // Subir el archivo para el índice 0
                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + indexToStartContrato, renamedFile.getName(), requestFile);
                                                archivosGeneral.add(body);

                                                getActivity().runOnUiThread(() -> {
                                                    imgComprobante.setImageBitmap(reduceBitmap);
                                                    imgComprobante.setVisibility(View.VISIBLE);
                                                });
                                            }
                                            Log.d("log", "No falta ningún archivo. Empezando desde el índice 3.");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (camaraContratoClienteAbierta) {
                    int indexToStartContrato = 3;
                    if (data != null) {
                        Log.d("MOD", "archivo seleccion de imagen 1.");
                        ClipData clipData2 = data.getClipData();
                        if (clipData2 != null) {
                            // Proceso para múltiples imágenes
                            List<Uri> urisToUpload2 = new ArrayList<>();

                            for (int i = 0; i < clipData2.getItemCount(); i++) {
                                uri = clipData2.getItemAt(i).getUri();
                                if (uri != null) {
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        urisToUpload2.add(uri); // Guarda el URI para más adelante
                                    }
                                }
                            }

                            // Procesar cada URI y asignar el índice correspondiente
                            for (int i = 0; i < urisToUpload2.size(); i++) {
                                uri = urisToUpload2.get(i);
                                int index = i;
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        Bitmap bitmap = BitmapFactory.decodeFile(path);
                                        Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                        File compressedFile = null;
                                        try {
                                            compressedFile = saveBitmapToFile(reduceBitmap);
                                        } catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }

                                        if (compressedFile != null) {
                                            int assignedIndex = findMissingIndexContrato();
                                            if (assignedIndex != -1) {
                                                // Renombrar el archivo comprimido con el sufijo correcto
                                                File renamedFile = new File(compressedFile.getParent(), assignedIndex + "CC.jpeg");
                                                if (compressedFile.renameTo(renamedFile)) {
                                                    Log.d("Archivo", "Archivo renombrado a: " + renamedFile.getAbsolutePath());

                                                    // Añadir solo el archivo renombrado a la lista de paths
                                                    pathsContratoCliente.add(renamedFile.getAbsolutePath());
                                                    pathsContratoCliente2.add(renamedFile.getAbsolutePath());

                                                    // Subir el archivo usando el archivo renombrado
                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + assignedIndex, renamedFile.getName(), requestFile);
                                                    archivosGeneral.add(body);

                                                    getActivity().runOnUiThread(() -> {
                                                        // Mostrar la imagen en el cuadro correspondiente
                                                        if (assignedIndex == 3) {
                                                            imgContratoFrente.setImageBitmap(reduceBitmap);
                                                            imgContratoFrente.setVisibility(View.VISIBLE);
                                                        } else if (assignedIndex == 4) {
                                                            imgContratoReverso.setImageBitmap(reduceBitmap);
                                                            imgContratoReverso.setVisibility(View.VISIBLE);
                                                        }
                                                    });
                                                    Log.d("MOD", "Archivo " + assignedIndex + " agregado: " + renamedFile.getAbsolutePath());
                                                }
                                            }
                                            else
                                            {
                                                pathsContratoCliente.clear();

                                                File renamedFile = new File(compressedFile.getParent(), indexToStartContrato + "CC.jpeg");
                                                if (compressedFile.renameTo(renamedFile)) {
                                                    pathsContratoCliente.add(renamedFile.getAbsolutePath());
                                                    pathsContratoCliente2.add(renamedFile.getAbsolutePath());

                                                    // Subir el archivo para el índice 0
                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + indexToStartContrato, renamedFile.getName(), requestFile);
                                                    archivosGeneral.add(body);

                                                    getActivity().runOnUiThread(() -> {
                                                        // Mostrar la imagen para el índice 0
                                                        if (indexToStartContrato == 3) {
                                                            imgContratoFrente.setImageBitmap(reduceBitmap);
                                                            imgContratoFrente.setVisibility(View.VISIBLE);
                                                        } else if (indexToStartContrato == 4) {
                                                            imgContratoReverso.setImageBitmap(reduceBitmap);
                                                            imgContratoReverso.setVisibility(View.VISIBLE);
                                                        }
                                                    });
                                                }
                                                Log.d("log", "No falta ningún archivo. Empezando desde el índice 3.");
                                            }
                                        }
                                    }
                            }
                        } else {
                            // Proceso para una sola imagen
                            Log.e("INFO", "Procesando una sola imagen.");
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        Bitmap bitmap = BitmapFactory.decodeFile(path);
                                        Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                        File compressedFile = null;
                                        try {
                                            compressedFile = saveBitmapToFile(reduceBitmap);
                                        } catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }

                                        if (compressedFile != null) {
                                            // Verificar el índice que falta
                                            int missingIndexIne = findMissingIndexContrato();
                                            if (missingIndexIne != -1) {
                                                // Renombrar el archivo comprimido con el sufijo correcto
                                                File renamedFile = new File(compressedFile.getParent(), missingIndexIne + "CC.jpeg");
                                                if (compressedFile.renameTo(renamedFile)) {
                                                    Log.d("Archivo", "Archivo renombrado a: " + renamedFile.getAbsolutePath());

                                                    pathsContratoCliente.add(renamedFile.getAbsolutePath());
                                                    pathsContratoCliente2.add(renamedFile.getAbsolutePath());

                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + missingIndexIne, renamedFile.getName(), requestFile);
                                                    archivosGeneral.add(body);

                                                    getActivity().runOnUiThread(() -> {
                                                        // Mostrar la imagen en el cuadro correspondiente
                                                        if (missingIndexIne == 3) {
                                                            imgContratoFrente.setImageBitmap(reduceBitmap);
                                                            imgContratoFrente.setVisibility(View.VISIBLE);
                                                        } else if (missingIndexIne == 4) {
                                                            imgContratoReverso.setImageBitmap(reduceBitmap);
                                                            imgContratoReverso.setVisibility(View.VISIBLE);
                                                        }
                                                    });

                                                    Log.d("MOD", "Archivo " + missingIndexIne + " agregado: " + renamedFile.getAbsolutePath());
                                                } else {
                                                    Log.e("ERROR", "No se pudo renombrar el archivo comprimido.");
                                                }
                                            } else
                                            {
                                                pathsContratoCliente.clear();

                                                File renamedFile = new File(compressedFile.getParent(), indexToStartContrato + "CC.jpeg");
                                                if (compressedFile.renameTo(renamedFile)) {
                                                    pathsContratoCliente.add(renamedFile.getAbsolutePath());
                                                    pathsContratoCliente2.add(renamedFile.getAbsolutePath());

                                                    // Subir el archivo para el índice 0
                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + indexToStartContrato, renamedFile.getName(), requestFile);
                                                    archivosGeneral.add(body);

                                                    getActivity().runOnUiThread(() -> {
                                                        // Mostrar la imagen para el índice 0
                                                        if (indexToStartContrato == 3) {
                                                            imgContratoFrente.setImageBitmap(reduceBitmap);
                                                            imgContratoFrente.setVisibility(View.VISIBLE);
                                                        } else if (indexToStartContrato == 4) {
                                                            imgContratoReverso.setImageBitmap(reduceBitmap);
                                                            imgContratoReverso.setVisibility(View.VISIBLE);
                                                        }
                                                    });
                                                }
                                                Log.d("log", "No falta ningún archivo. Empezando desde el índice 3.");
                                            }
                                        }
                                    }
                            }
                        }
                    }
                }

                if (camaraIneClienteAbierta) {
                    int indexToStartIne = 0;
                    if (data != null) {
                        ClipData clipData3 = data.getClipData();
                        if (clipData3 != null) {
                            List<Uri> urisToUpload3 = new ArrayList<>();

                            for (int i = 0; i < clipData3.getItemCount(); i++) {
                                uri = clipData3.getItemAt(i).getUri();
                                if (uri != null) {
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        urisToUpload3.add(uri); // Guarda el URI para más adelante
                                    }
                                }
                            }

                            // Procesa cada URI y asigna el índice correspondiente
                            for (int i = 0; i < urisToUpload3.size(); i++) {
                                uri = urisToUpload3.get(i);
                                int index = i;
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        Bitmap bitmap = BitmapFactory.decodeFile(path);
                                        Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                        File compressedFile = null;
                                        try {
                                            compressedFile = saveBitmapToFile(reduceBitmap);
                                        } catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }

                                        if (compressedFile != null) {
                                            int assignedIndex = findMissingIndexIne();
                                            if (assignedIndex != -1) {
                                                // Cambiar el nombre del archivo comprimido para que tenga el sufijo correcto
                                                File renamedFile = new File(compressedFile.getParent(), assignedIndex + "CC.jpeg");
                                                if (compressedFile.renameTo(renamedFile)) {
                                                    // El archivo ha sido renombrado correctamente
                                                    Log.d("Archivo", "Archivo renombrado a: " + renamedFile.getAbsolutePath());

                                                    // Actualiza pathsIneAval con el nuevo nombre del archivo
                                                    pathsIneCliente.add(renamedFile.getAbsolutePath());
                                                    pathsIneCliente2.add(renamedFile.getAbsolutePath());

                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + assignedIndex, renamedFile.getName(), requestFile);
                                                    archivosGeneral.add(body);
                                                    getActivity().runOnUiThread(() -> {
                                                        // Mostrar la imagen en el cuadro correspondiente
                                                        if (assignedIndex == 0) { // INE Frente
                                                            imgIneFrente.setImageBitmap(reduceBitmap);
                                                            imgIneFrente.setVisibility(View.VISIBLE);
                                                        } else if (assignedIndex == 1) { // INE Reverso
                                                            imgIneReverso.setImageBitmap(reduceBitmap);
                                                            imgIneReverso.setVisibility(View.VISIBLE);
                                                        }
                                                    });
                                                    Log.d("MOD", "Archivo " + assignedIndex + " agregado: " + renamedFile.getAbsolutePath());
                                                }
                                            } else
                                            {
                                                pathsIneCliente.clear();

                                                File renamedFile = new File(compressedFile.getParent(), indexToStartIne + "CC.jpeg");
                                                if (compressedFile.renameTo(renamedFile)) {
                                                    // Añadir el archivo renombrado a las listas
                                                    pathsIneCliente.add(renamedFile.getAbsolutePath());
                                                    pathsIneCliente2.add(renamedFile.getAbsolutePath());

                                                    // Subir el archivo con el índice 0
                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + indexToStartIne, renamedFile.getName(), requestFile);
                                                    archivosGeneral.add(body);

                                                    // Mostrar la imagen de la UI para el índice 0
                                                    getActivity().runOnUiThread(() -> {
                                                        imgIneFrente.setImageBitmap(reduceBitmap);
                                                        imgIneFrente.setVisibility(View.VISIBLE);
                                                    });

                                                    Log.d("MOD", "Archivo " + indexToStartIne + " agregado: " + renamedFile.getAbsolutePath());
                                                } else {
                                                    Log.e("ERROR", "No se pudo renombrar el archivo comprimido para el índice 0.");
                                                }
                                                Log.e("INFO", "No falta ningún archivo. Empezando desde el índice 0.");
                                            }
                                        }
                                    }
                            }
                        } else {
                            // Para un solo archivo
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        Bitmap bitmap = BitmapFactory.decodeFile(path);
                                        Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                        File compressedFile = null;
                                        try {
                                            compressedFile = saveBitmapToFile(reduceBitmap);
                                        } catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }

                                        if (compressedFile != null) {
                                            // Verificar el índice que falta
                                            int missingIndexIne = findMissingIndexIne();
                                            if (missingIndexIne != -1) {
                                                // Cambiar el nombre del archivo comprimido para que tenga el sufijo correcto
                                                File renamedFile = new File(compressedFile.getParent(), missingIndexIne + "CC.jpeg");
                                                if (compressedFile.renameTo(renamedFile)) {
                                                    // El archivo ha sido renombrado correctamente
                                                    Log.d("Archivo", "Archivo renombrado a: " + renamedFile.getAbsolutePath());

                                                    pathsIneCliente.add(renamedFile.getAbsolutePath());
                                                    pathsIneCliente2.add(renamedFile.getAbsolutePath());

                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + missingIndexIne, renamedFile.getName(), requestFile);
                                                    archivosGeneral.add(body);
                                                    getActivity().runOnUiThread(() -> {
                                                        // Mostrar la imagen en el cuadro correspondiente
                                                        if (missingIndexIne == 0) { // INE Frente
                                                            imgIneFrente.setImageBitmap(reduceBitmap);
                                                            imgIneFrente.setVisibility(View.VISIBLE);
                                                        } else if (missingIndexIne == 1) { // INE Reverso
                                                            imgIneReverso.setImageBitmap(reduceBitmap);
                                                            imgIneReverso.setVisibility(View.VISIBLE);
                                                        }
                                                    });
                                                    Log.d("MOD", "Archivo " + missingIndexIne + " agregado: " + renamedFile.getAbsolutePath());
                                                } else {
                                                    Log.e("ERROR", "No se pudo renombrar el archivo comprimido.");
                                                }
                                            }else
                                            {
                                                pathsIneCliente.clear();

                                                File renamedFile = new File(compressedFile.getParent(), indexToStartIne + "CC.jpeg");
                                                if (compressedFile.renameTo(renamedFile)) {
                                                    // Añadir el archivo renombrado a las listas
                                                    pathsIneCliente.add(renamedFile.getAbsolutePath());
                                                    pathsIneCliente2.add(renamedFile.getAbsolutePath());

                                                    // Subir el archivo con el índice 0
                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + indexToStartIne, renamedFile.getName(), requestFile);
                                                    archivosGeneral.add(body);

                                                    // Mostrar la imagen de la UI para el índice 0
                                                    getActivity().runOnUiThread(() -> {
                                                        imgIneFrente.setImageBitmap(reduceBitmap);
                                                        imgIneFrente.setVisibility(View.VISIBLE);
                                                    });

                                                    Log.d("MOD", "Archivo " + indexToStartIne + " agregado: " + renamedFile.getAbsolutePath());
                                                } else {
                                                    Log.e("ERROR", "No se pudo renombrar el archivo comprimido para el índice 0.");
                                                }
                                                Log.e("INFO", "No falta ningún archivo. Empezando desde el índice 0.");
                                            }
                                        }
                                    }
                            }
                        }
                    }
                    //btnImagenesGarantiasAval.setText("Garantías (" + pathsGarantiasAval.size() + ")");
                }

                if (camaraFotoAbierta) {
                    if (data != null) {
                        ClipData clipData = data.getClipData();
                        if (clipData != null) {
                            for (int i = 0; i < clipData.getItemCount(); i++) {
                                uri = clipData.getItemAt(i).getUri();
                                if (uri != null) {
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                        if (path != null) {
                                            File file = new File(path);
                                            if (file.exists()) {
                                                try {
                                                    pathsFotoCliente.add(path);
                                                    pathsFotoCliente2.add(path);

                                                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                                                    Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                                    File compressedFile = saveBitmapToFile(reduceBitmap);

                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + fileIndex, "5CC.jpeg", requestFile);
                                                    fileIndex++; // Aumentar el índice para el próximo archivo
                                                    archivosGeneral.add(body);
                                                    getActivity().runOnUiThread(() -> {
                                                        imgFoto.setImageBitmap(reduceBitmap);
                                                        imgFoto.setVisibility(View.VISIBLE);
                                                    });

                                                } catch (IOException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        }
                                }
                            }
                        } else {
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        pathsFotoCliente.add(path);
                                        pathsFotoCliente2.add(path);

                                        Bitmap bitmap = BitmapFactory.decodeFile(path);
                                        //banderaFotoAvales = pathsFotoCliente.size() - 1;
                                        Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                        File compressedFile = null;
                                        try {
                                            compressedFile = saveBitmapToFile(reduceBitmap);
                                        } catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }

                                        RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                        MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + fileIndex, "5CC.jpeg", requestFile);
                                        fileIndex++; // Aumentar el índice para el próximo archivo
                                        archivosGeneral.add(body);
                                        getActivity().runOnUiThread(() -> {
                                            imgFoto.setImageBitmap(reduceBitmap);
                                            imgFoto.setVisibility(View.VISIBLE);
                                        });

                                    }
                            }
                        }
                    } else {
                        path = RealPathUtil.getRealPath(getActivity(), image_uri);
                            if (path != null) {
                                Bitmap bitmap = BitmapFactory.decodeFile(path);
                                pathsFotoCliente.add(path);
                                pathsFotoCliente2.add(path);

                                //banderaComprobantesAvales = pathsFotoCliente.size() - 1;
                                Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                File compressedFile = null;
                                try {
                                    compressedFile = saveBitmapToFile(reduceBitmap);
                                } catch (IOException e) {
                                    throw new RuntimeException(e);
                                }

                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + fileIndex, "5CC.jpeg", requestFile);
                                fileIndex++; // Aumentar el índice para el próximo archivo
                                archivosGeneral.add(body);
                                getActivity().runOnUiThread(() -> {
                                    imgFoto.setImageBitmap(reduceBitmap);
                                    imgFoto.setVisibility(View.VISIBLE);
                                });
                            }
                    }
                    //btnImagenesFotoAval.setText("FOTO DEL AVAL (" + pathsFotoAval.size() + ")");
                }

                if (camaraFachadaAbierta) {
                    if (data != null) {
                        ClipData clipData = data.getClipData();
                        if (clipData != null) {
                            for (int i = 0; i < clipData.getItemCount(); i++) {
                                uri = clipData.getItemAt(i).getUri();
                                if (uri != null) {
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                        if (path != null) {
                                            File file = new File(path);
                                            if (file.exists()) {
                                                try {
                                                    pathsFachadaCliente.add(path);
                                                    pathsFachadaCliente2.add(path);

                                                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                                                    Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                                    File compressedFile = saveBitmapToFile(reduceBitmap);

                                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + fileIndex, "6CC.jpeg", requestFile);
                                                    fileIndex++; // Aumentar el índice para el próximo archivo
                                                    archivosGeneral.add(body);
                                                    getActivity().runOnUiThread(() -> {
                                                        imgFachada.setImageBitmap(reduceBitmap);
                                                        imgFachada.setVisibility(View.VISIBLE);
                                                    });
                                                    Log.d("Archivos", "Archivo Subido 1");
                                                } catch (IOException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        }
                                }
                            }
                        } else {
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        Bitmap bitmap = BitmapFactory.decodeFile(path);
                                        pathsFachadaCliente.add(path);
                                        pathsFachadaCliente2.add(path);

                                        Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                        File compressedFile = null;
                                        try {
                                            compressedFile = saveBitmapToFile(reduceBitmap);
                                        } catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }
                                        //banderaFachadaAvales = pathsComprobantesAval.size() - 1;
                                        RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                        MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + fileIndex, "6CC.jpeg", requestFile);
                                        fileIndex++; // Aumentar el índice para el próximo archivo
                                        archivosGeneral.add(body);
                                        getActivity().runOnUiThread(() -> {
                                            imgFachada.setImageBitmap(reduceBitmap);
                                            imgFachada.setVisibility(View.VISIBLE);
                                        });
                                        Log.d("Archivos", "Archivo Subido 2");
                                    }
                            }
                        }
                    } else {
                        path = RealPathUtil.getRealPath(getActivity(), image_uri);
                            if (path != null) {
                                Bitmap bitmap = BitmapFactory.decodeFile(path);
                                pathsFachadaCliente.add(path);
                                pathsFachadaCliente2.add(path);

                                //banderaComprobantesAvales = pathsFachadaCliente.size() - 1;
                                Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                File compressedFile = null;
                                try {
                                    compressedFile = saveBitmapToFile(reduceBitmap);
                                } catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                //banderaFachadaAvales = pathsComprobantesAval.size() - 1;
                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + fileIndex, "6CC.jpeg", requestFile);
                                fileIndex++; // Aumentar el índice para el próximo archivo
                                archivosGeneral.add(body);
                                getActivity().runOnUiThread(() -> {
                                    imgFachada.setImageBitmap(reduceBitmap);
                                    imgFachada.setVisibility(View.VISIBLE);
                                });
                                Log.d("Archivos", "Archivo Subido 3");
                            }
                    }
                    //btnImagenesFachadaAval.setText("FACHADA (" + pathsFachadaAval.size() + ")");
                }
                // CAMARA DE AVAL
                if (camaraIneAvalAbierta) {
                    int indexToStartIneA = 0;
                    if (data != null) {
                        ClipData clipData2 = data.getClipData();
                        if (clipData2 != null) {
                            List<Uri> urisToUpload2 = new ArrayList<>();

                            for (int i = 0; i < clipData2.getItemCount(); i++) {
                                uri = clipData2.getItemAt(i).getUri();
                                if (uri != null) {
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        urisToUpload2.add(uri); // Guarda el URI para más adelante
                                    }
                                }
                            }

                            Log.d("uri2u", "onActivityResult: " + urisToUpload2.toString());

                            // Procesa cada URI y asigna el índice correspondiente
                            for (int i = 0; i < urisToUpload2.size(); i++) {
                                uri = urisToUpload2.get(i);
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                if (path != null) {
                                    Log.d("path", "onActivityResult: " + path);
                                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                                    Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                    File compressedFile = null;
                                    try {
                                        compressedFile = saveBitmapToFile(reduceBitmap);
                                    } catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }

                                    if (compressedFile != null) {
                                        Log.d("cf", "onActivityResult: " + compressedFile);
                                        int assignedIndex = findMissingIndexIneA();
                                        if (i != -1) {
                                            // Cambiar el nombre del archivo comprimido para que tenga el sufijo correcto
                                            File renamedFile = new File(compressedFile.getParent(), i + "CA.jpeg");
                                            if (compressedFile.renameTo(renamedFile)) {
                                                // El archivo ha sido renombrado correctamente
                                                Log.d("Archivo", "Archivo renombrado a: " + renamedFile.getAbsolutePath());

                                                // Actualiza pathsIneAval con el nuevo nombre del archivo
                                                pathsIneAval.add(renamedFile.getAbsolutePath());
                                                pathsIneAval2.add(renamedFile.getAbsolutePath());

                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + i, renamedFile.getName(), requestFile);
                                                archivosGeneral.add(body);

                                                // Mostrar la imagen en el cuadro correspondiente
                                                if (i == 0) { // INE Frente
                                                    Log.d("asdasd0", "onActivityResult: ");
                                                    imgIneFrenteA.setImageBitmap(reduceBitmap);
                                                    imgIneFrenteA.setVisibility(View.VISIBLE);
                                                } else if (i == 1) { // INE Reverso
                                                    Log.d("asdasd1", "onActivityResult: ");
                                                    imgIneReversoA.setImageBitmap(reduceBitmap);
                                                    imgIneReversoA.setVisibility(View.VISIBLE);
                                                }

                                                Log.d("MOD", "Archivo " + assignedIndex + " agregado: " + renamedFile.getAbsolutePath());
                                            }
                                        }
                                        else
                                        {
                                            pathsIneAval.clear();

                                            File renamedFile = new File(compressedFile.getParent(), indexToStartIneA + "CA.jpeg");
                                            if (compressedFile.renameTo(renamedFile)) {
                                                // Añadir el archivo renombrado a las listas
                                                pathsIneAval.add(renamedFile.getAbsolutePath());
                                                pathsIneAval2.add(renamedFile.getAbsolutePath());

                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + assignedIndex, renamedFile.getName(), requestFile);
                                                archivosGeneral.add(body);

                                                // Mostrar la imagen en el cuadro correspondiente
                                                if (assignedIndex == 0) { // INE Frente
                                                    imgIneFrente.setImageBitmap(reduceBitmap);
                                                    imgIneFrente.setVisibility(View.VISIBLE);
                                                } else if (assignedIndex == 1) { // INE Reverso
                                                    imgIneReverso.setImageBitmap(reduceBitmap);
                                                    imgIneReverso.setVisibility(View.VISIBLE);
                                                }

                                                Log.d("MOD", "Archivo " + indexToStartIneA + " agregado: " + renamedFile.getAbsolutePath());
                                            } else {
                                                Log.e("ERROR", "No se pudo renombrar el archivo comprimido para el índice 0.");
                                            }
                                            Log.e("INFO", "No falta ningún archivo. Empezando desde el índice 0.");
                                        }
                                    }
                                }
                            }
                        } else {
                            // Para un solo archivo
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                if (path != null) {
                                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                                    Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                    File compressedFile = null;
                                    try {
                                        compressedFile = saveBitmapToFile(reduceBitmap);
                                    } catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }

                                    if (compressedFile != null) {
                                        // Verificar el índice que falta
                                        int missingIndexIne = findMissingIndexIneA();
                                        if (missingIndexIne != -1) {
                                            // Cambiar el nombre del archivo comprimido para que tenga el sufijo correcto
                                            File renamedFile = new File(compressedFile.getParent(), missingIndexIne + "CA.jpeg");
                                            if (compressedFile.renameTo(renamedFile)) {
                                                // El archivo ha sido renombrado correctamente
                                                Log.d("Archivo", "Archivo renombrado a: " + renamedFile.getAbsolutePath());

                                                pathsIneAval.add(renamedFile.getAbsolutePath());
                                                pathsIneAval2.add(renamedFile.getAbsolutePath());

                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + missingIndexIne, renamedFile.getName(), requestFile);
                                                archivosGeneral.add(body);

                                                // Mostrar la imagen en el cuadro correspondiente
                                                if (missingIndexIne == 0) { // INE Frente
                                                    imgIneFrenteA.setImageBitmap(reduceBitmap);
                                                    imgIneFrenteA.setVisibility(View.VISIBLE);
                                                } else if (missingIndexIne == 1) { // INE Reverso
                                                    imgIneReversoA.setImageBitmap(reduceBitmap);
                                                    imgIneReversoA.setVisibility(View.VISIBLE);
                                                }

                                                Log.d("MOD", "Archivo " + missingIndexIne + " agregado: " + renamedFile.getAbsolutePath());
                                            } else {
                                                Log.e("ERROR", "No se pudo renombrar el archivo comprimido.");
                                            }
                                        }else
                                        {
                                            pathsIneAval.clear();

                                            File renamedFile = new File(compressedFile.getParent(), indexToStartIneA + "CA.jpeg");
                                            if (compressedFile.renameTo(renamedFile)) {
                                                // Añadir el archivo renombrado a las listas
                                                pathsIneAval.add(renamedFile.getAbsolutePath());
                                                pathsIneAval2.add(renamedFile.getAbsolutePath());

                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + indexToStartIneA, renamedFile.getName(), requestFile);
                                                archivosGeneral.add(body);

                                                // Mostrar la imagen en el cuadro correspondiente
                                                if (indexToStartIneA == 0) { // INE Frente
                                                    imgIneFrente.setImageBitmap(reduceBitmap);
                                                    imgIneFrente.setVisibility(View.VISIBLE);
                                                } else if (indexToStartIneA == 1) { // INE Reverso
                                                    imgIneReverso.setImageBitmap(reduceBitmap);
                                                    imgIneReverso.setVisibility(View.VISIBLE);
                                                }

                                                Log.d("MOD", "Archivo " + indexToStartIneA + " agregado: " + renamedFile.getAbsolutePath());
                                            } else {
                                                Log.e("ERROR", "No se pudo renombrar el archivo comprimido para el índice 0.");
                                            }
                                            Log.e("INFO", "No falta ningún archivo. Empezando desde el índice 0.");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    //btnImagenesGarantiasAval.setText("Garantías (" + pathsGarantiasAval.size() + ")");
                }

                if (camaraComprobantesAvalAbierta) {
                    if (data != null) {
                        ClipData clipData = data.getClipData();
                        if (clipData != null) {
                            for (int i = 0; i < clipData.getItemCount(); i++) {
                                uri = clipData.getItemAt(i).getUri();
                                if (uri != null) {
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        File file = new File(path);
                                        if (file.exists()) {
                                            try {
                                                pathsComprobantesAval.add(path);
                                                pathsComprobantesAval2.add(path);

                                                Bitmap bitmap = BitmapFactory.decodeFile(path);
                                                Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                                File compressedFile = saveBitmapToFile(reduceBitmap);

                                                // Aquí nombramos el archivo como "2CA.jpeg"
                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + fileIndexAval, "2CA.jpeg", requestFile);
                                                fileIndexAval++; // Aumentar el índice para el próximo archivo
                                                archivosGeneral.add(body);

                                                // Mostrar la imagen en el cuadro correspondiente
                                                imgComprobanteA.setImageBitmap(reduceBitmap);
                                                imgComprobanteA.setVisibility(View.VISIBLE);

                                                Log.d("MOD", "Archivo 2CA.jpeg agregado: " + compressedFile.getAbsolutePath());
                                            } catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                }
                            }
                        } else {
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                if (path != null) {
                                    File file = new File(path);
                                    if (file.exists()) {
                                        try {
                                            Bitmap bitmap = BitmapFactory.decodeFile(path);
                                            pathsComprobantesAval.add(path);
                                            pathsComprobantesAval2.add(path);

                                            Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                            File compressedFile = saveBitmapToFile(reduceBitmap);

                                            RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                            MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + fileIndexAval, "2CA.jpeg", requestFile);
                                            fileIndexAval++; // Aumentar el índice para el próximo archivo
                                            archivosGeneral.add(body);

                                            imgComprobanteA.setImageBitmap(reduceBitmap);
                                            imgComprobanteA.setVisibility(View.VISIBLE);
                                            Log.d("MOD", "Archivo único 2CA.jpeg agregado: " + compressedFile.getAbsolutePath());
                                        } catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }
                        }
                    }
                    //btnImagenesComprobantesAval.setText("COMPROBANTE DE DOMICILIO (" + pathsComprobantesAval.size() + ")");
                }
                if (camaraGarantiasAvalAbierta) {
                    int indexToStart = 0;
                    if (data != null) {
                        ClipData clipData = data.getClipData();
                        if (clipData != null) {
                            List<Uri> urisToUpload = new ArrayList<>();

                            for (int i = 0; i < clipData.getItemCount(); i++) {
                                uri = clipData.getItemAt(i).getUri();
                                if (uri != null) {
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        urisToUpload.add(uri); // Guarda el URI para más adelante
                                    }
                                }
                            }

                            // Procesa cada URI y asigna el índice correspondiente
                            for (int i = 0; i < urisToUpload.size(); i++) {
                                uri = urisToUpload.get(i);
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                if (path != null) {
                                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                                    Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                    File compressedFile = null;
                                    try {
                                        compressedFile = saveBitmapToFile(reduceBitmap);
                                    } catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }

                                    if (compressedFile != null) {
                                        int assignedIndex = findMissingIndexA();
                                        if (assignedIndex != -1) {
                                            // Cambiar el nombre del archivo comprimido para que tenga el sufijo correcto
                                            File renamedFile = new File(compressedFile.getParent(), assignedIndex + "GA.jpeg");
                                            if (compressedFile.renameTo(renamedFile)) {
                                                // El archivo ha sido renombrado correctamente
                                                Log.d("Archivo", "Archivo renombrado a: " + renamedFile.getAbsolutePath());

                                                // Actualiza pathsGarantiasAval con el nuevo nombre del archivo
                                                pathsGarantiasAval.add(renamedFile.getAbsolutePath());
                                                pathsGarantiasAval2.add(renamedFile.getAbsolutePath());

                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_aval_" + assignedIndex, renamedFile.getName(), requestFile);
                                                archivosGeneral.add(body);
                                                displayImageGA(reduceBitmap, assignedIndex); // Mostrar la imagen en la UI
                                                Log.d("MOD", "Archivo " + assignedIndex + " agregado: " + renamedFile.getAbsolutePath());
                                            }
                                        } else {
                                            pathsGarantiasAval.clear();
                                            // Si no falta ningún índice, empezar desde el índice 0
                                            Log.d("log", "No falta ningún archivo. Empezando desde el índice 0.");

                                            // Aquí generas y subes el archivo para el índice 0 (como si fuera el primero)
                                            File renamedFile2 = new File(compressedFile.getParent(), indexToStart + "GA.jpeg");
                                            if (compressedFile.renameTo(renamedFile2)) {
                                                pathsGarantiasAval.add(renamedFile2.getAbsolutePath());
                                                pathsGarantiasAval2.add(renamedFile2.getAbsolutePath());
                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile2);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_aval_" + indexToStart, renamedFile2.getName(), requestFile);
                                                archivosGeneral.add(body);
                                                getActivity().runOnUiThread(() -> {
                                                    displayImageGA(reduceBitmap, indexToStart); // Mostrar la imagen en la UI
                                                });
                                            }
                                        }
                                    }
                                }
                            }
                        } else {
                            Log.d("log", "ENTRO EN PRIMER IF.");
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                if (path != null) {
                                    Bitmap bitmap = BitmapFactory.decodeFile(path);

                                    Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                    File compressedFile = null;
                                    try {
                                        compressedFile = saveBitmapToFile(reduceBitmap);
                                    } catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }

                                    // Verifica el índice que falta y carga el archivo correspondiente
                                    int missingIndex = findMissingIndexA();
                                    if (missingIndex != -1) {
                                        // Cambiar el nombre del archivo comprimido para que tenga el sufijo correcto
                                        File renamedFile = new File(compressedFile.getParent(), missingIndex + "GA.jpeg");
                                        if (compressedFile.renameTo(renamedFile)) {
                                            pathsGarantiasAval.add(renamedFile.getAbsolutePath());
                                            pathsGarantiasAval2.add(renamedFile.getAbsolutePath());

                                            RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                            MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_aval_" + missingIndex, renamedFile.getName(), requestFile);
                                            archivosGeneral.add(body);
                                            displayImageGA(reduceBitmap, missingIndex); // Mostrar la imagen en la UI
                                        }
                                    } else {
                                        pathsGarantiasAval.clear();
                                        // Si no falta ningún índice, empezar desde el índice 0
                                        Log.d("log", "No falta ningún archivo. Empezando desde el índice 0.");

                                        // Aquí generas y subes el archivo para el índice 0 (como si fuera el primero)
                                        File renamedFile2 = new File(compressedFile.getParent(), indexToStart + "GA.jpeg");
                                        if (compressedFile.renameTo(renamedFile2)) {
                                            pathsGarantiasAval.add(renamedFile2.getAbsolutePath());
                                            pathsGarantiasAval2.add(renamedFile2.getAbsolutePath());
                                            RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile2);
                                            MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_aval_" + indexToStart, renamedFile2.getName(), requestFile);
                                            archivosGeneral.add(body);
                                            getActivity().runOnUiThread(() -> {
                                                displayImageGA(reduceBitmap, indexToStart); // Mostrar la imagen en la UI
                                            });
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        path = RealPathUtil.getRealPath(getActivity(), image_uri);
                        if (path != null) {
                            Bitmap bitmap = BitmapFactory.decodeFile(path);
                            pathsGarantiasAval.add(path);
                            pathsGarantiasAval2.add(path);

                            Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                            File compressedFile = null;
                            try {
                                compressedFile = saveBitmapToFile(reduceBitmap);
                            } catch (IOException e) {
                                throw new RuntimeException(e);
                            }

                            // Verifica el índice que falta y carga el archivo correspondiente
                            int missingIndex = findMissingIndexA();
                            if (missingIndex != -1) {
                                // Cambiar el nombre del archivo comprimido para que tenga el sufijo correcto
                                File renamedFile = new File(compressedFile.getParent(), missingIndex + "GA.jpeg");
                                if (compressedFile.renameTo(renamedFile)) {
                                    pathsGarantiasAval.add(renamedFile.getAbsolutePath());
                                    pathsGarantiasAval2.add(renamedFile.getAbsolutePath());

                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile);
                                    MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_aval_" + missingIndex, renamedFile.getName(), requestFile);
                                    archivosGeneral.add(body);
                                    displayImageGA(reduceBitmap, missingIndex); // Mostrar la imagen en la UI
                                }
                            } else {
                                pathsGarantiasAval.clear();
                                // Si no falta ningún índice, empezar desde el índice 0
                                Log.d("log", "No falta ningún archivo. Empezando desde el índice 0.");

                                // Aquí generas y subes el archivo para el índice 0 (como si fuera el primero)
                                File renamedFile2 = new File(compressedFile.getParent(), indexToStart + "GA.jpeg");
                                if (compressedFile.renameTo(renamedFile2)) {
                                    pathsGarantiasAval.add(renamedFile2.getAbsolutePath());
                                    pathsGarantiasAval2.add(renamedFile2.getAbsolutePath());
                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), renamedFile2);
                                    MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_aval_" + indexToStart, renamedFile2.getName(), requestFile);
                                    archivosGeneral.add(body);
                                    getActivity().runOnUiThread(() -> {
                                        displayImageGA(reduceBitmap, indexToStart); // Mostrar la imagen en la UI
                                    });
                                }
                            }
                        }
                    }
                    Log.d("log", "Cantidad de fotos actualmente en pathsGarantiasAval: " + pathsGarantiasAval.size());
                    //btnImagenesGarantiasAval.setText("Garantías (" + pathsGarantiasAval.size() + ")");
                }
                if (camaraFotoAvalAbierta) {
                    if (data != null) {
                        ClipData clipData = data.getClipData();
                        if (clipData != null) {
                            for (int i = 0; i < clipData.getItemCount(); i++) {
                                uri = clipData.getItemAt(i).getUri();
                                if (uri != null) {
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        File file = new File(path);
                                        if (file.exists()) {
                                            try {
                                                pathsComprobantesAval.add(path);
                                                pathsComprobantesAval2.add(path);

                                                Bitmap bitmap = BitmapFactory.decodeFile(path);
                                                Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                                File compressedFile = saveBitmapToFile(reduceBitmap);

                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + fileIndexAval, "3CA.jpeg", requestFile);
                                                fileIndexAval++; // Aumentar el índice para el próximo archivo
                                                archivosGeneral.add(body);

                                                imgFotoA.setImageBitmap(reduceBitmap);
                                                imgFotoA.setVisibility(View.VISIBLE);

                                            } catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                }
                            }
                        } else {
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                if (path != null) {
                                    pathsComprobantesAval.add(path);
                                    pathsComprobantesAval2.add(path);

                                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                                    banderaFotoAvales = pathsComprobantesAval.size() - 1;
                                    Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                    File compressedFile = null;
                                    try {
                                        compressedFile = saveBitmapToFile(reduceBitmap);
                                    } catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }

                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + fileIndexAval, "3CA.jpeg", requestFile);
                                    fileIndexAval++; // Aumentar el índice para el próximo archivo
                                    archivosGeneral.add(body);

                                    imgFotoA.setImageBitmap(reduceBitmap);
                                    imgFotoA.setVisibility(View.VISIBLE);

                                }
                            }
                        }
                    } else {
                        path = RealPathUtil.getRealPath(getActivity(), image_uri);
                        if (path != null) {
                            Bitmap bitmap = BitmapFactory.decodeFile(path);
                            pathsComprobantesAval.add(path);
                            pathsComprobantesAval2.add(path);

                            banderaComprobantesAvales = pathsComprobantesAval.size() - 1;
                            Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                            File compressedFile = null;
                            try {
                                compressedFile = saveBitmapToFile(reduceBitmap);
                            } catch (IOException e) {
                                throw new RuntimeException(e);
                            }

                            RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                            MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + fileIndexAval, "3CA.jpeg", requestFile);
                            fileIndexAval++; // Aumentar el índice para el próximo archivo
                            archivosGeneral.add(body);

                            imgFotoA.setImageBitmap(reduceBitmap);
                            imgFotoA.setVisibility(View.VISIBLE);

                        }
                    }
                    //btnImagenesFotoAval.setText("FOTO DEL AVAL (" + pathsFotoAval.size() + ")");
                }
                if (camaraFachadaAvalAbierta) {
                    if (data != null) {
                        ClipData clipData = data.getClipData();
                        if (clipData != null) {
                            for (int i = 0; i < clipData.getItemCount(); i++) {
                                uri = clipData.getItemAt(i).getUri();
                                if (uri != null) {
                                    path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null) {
                                        File file = new File(path);
                                        if (file.exists()) {
                                            try {
                                                pathsComprobantesAval.add(path);
                                                pathsComprobantesAval2.add(path);

                                                Bitmap bitmap = BitmapFactory.decodeFile(path);
                                                Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                                File compressedFile = saveBitmapToFile(reduceBitmap);

                                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + fileIndexAval, "4CA.jpeg", requestFile);
                                                fileIndexAval++; // Aumentar el índice para el próximo archivo
                                                archivosGeneral.add(body);
                                                imgFachadaA.setImageBitmap(reduceBitmap);
                                                imgFachadaA.setVisibility(View.VISIBLE);

                                            } catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                }
                            }
                        } else {
                            uri = data.getData();
                            if (uri != null) {
                                path = RealPathUtil.getRealPath(getActivity(), uri);
                                if (path != null) {
                                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                                    pathsComprobantesAval.add(path);
                                    pathsComprobantesAval2.add(path);

                                    Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                                    File compressedFile = null;
                                    try {
                                        compressedFile = saveBitmapToFile(reduceBitmap);
                                    } catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                    //banderaFachadaAvales = pathsComprobantesAval.size() - 1;
                                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + fileIndexAval, "4CA.jpeg", requestFile);
                                    fileIndexAval++; // Aumentar el índice para el próximo archivo
                                    archivosGeneral.add(body);

                                    imgFachadaA.setImageBitmap(reduceBitmap);
                                    imgFachadaA.setVisibility(View.VISIBLE);

                                }
                            }
                        }
                    } else {
                        path = RealPathUtil.getRealPath(getActivity(), image_uri);
                        if (path != null) {
                            Bitmap bitmap = BitmapFactory.decodeFile(path);
                            pathsComprobantesAval.add(path);
                            pathsComprobantesAval2.add(path);

                            banderaComprobantesAvales = pathsComprobantesAval.size() - 1;
                            Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                            File compressedFile = null;
                            try {
                                compressedFile = saveBitmapToFile(reduceBitmap);
                            } catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            //banderaFachadaAvales = pathsComprobantesAval.size() - 1;
                            RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                            MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + fileIndexAval, "4CA.jpeg", requestFile);
                            fileIndexAval++; // Aumentar el índice para el próximo archivo
                            archivosGeneral.add(body);

                            imgFachadaA.setImageBitmap(reduceBitmap);
                            imgFachadaA.setVisibility(View.VISIBLE);

                        }
                    }
                    //btnImagenesFachadaAval.setText("FACHADA (" + pathsFachadaAval.size() + ")");
                }
            }
        }
    }

    // Método para encontrar el índice que falta
    private int findMissingIndexA() {
        // Definir el rango de índices esperados
        Set<Integer> existingIndices = new HashSet<>();

        // Recorrer las rutas de los archivos garantizados
        for (String path : pathsGarantiasAval) {
            String fileName = new File(path).getName();

            // Verificar que el sufijo sea "GA" antes de procesar el índice
            if (fileName.endsWith("GA.jpeg")) {
                int index = Integer.parseInt(fileName.substring(0, 1)); // Obtener el primer carácter (índice)
                existingIndices.add(index);
                Log.d("Archivos", "Archivo encontrado: " + fileName + " con índice: " + index);
            } else {
                Log.d("Archivos", "Archivo ignorado (no es GA): " + fileName);
            }
        }

        // Si no se encontró ningún archivo GC, marcar todos los índices como faltantes
        if (existingIndices.isEmpty()) {
            Log.d("Indices", "No se encontró ningún archivo Ine, se marcan todos los índices como faltantes.");
            return -1; // Retornar un valor especial que indique que todos los índices están faltantes
        }
        // Verificar índices existentes
        Log.d("Indices existentes1", existingIndices.toString());

        // Buscar el primer índice que falta
        for (int i = 0; i <= 3; i++) { // Asumiendo que estamos buscando hasta el índice 2
            if (!existingIndices.contains(i)) {
                Log.d("Indices", "Índice faltante encontrado: " + i);
                return i; // Retornar el índice faltante
            }
        }

        Log.d("Indices", "No falta ningún índice.");
        return -1; // Si no falta ningún índice
    }

    // Método para encontrar el índice que falta
    private int findMissingIndex() {
        // Definir el rango de índices esperados
        Set<Integer> existingIndices = new HashSet<>();

        // Recorrer las rutas de los archivos garantizados
        for (String path : pathsGarantiasCliente) {
            String fileName = new File(path).getName();

            // Verificar que el sufijo sea "GA" antes de procesar el índice
            if (fileName.endsWith("GC.jpeg")) {
                int index = Integer.parseInt(fileName.substring(0, 1)); // Obtener el primer carácter (índice)
                existingIndices.add(index);
                Log.d("Archivos", "Archivo encontrado: " + fileName + " con índice: " + index);
            } else {
                Log.d("Archivos", "Archivo ignorado (no es GC): " + fileName);
            }
        }

        // Si no se encontró ningún archivo GC, marcar todos los índices como faltantes
        if (existingIndices.isEmpty()) {
            Log.d("Indices", "No se encontró ningún archivo Ine, se marcan todos los índices como faltantes.");
            return -1; // Retornar un valor especial que indique que todos los índices están faltantes
        }
        // Verificar índices existentes
        Log.d("Indices existentes2", existingIndices.toString());

        // Buscar el primer índice que falta
        for (int i = 0; i <= 3; i++) { // Asumiendo que estamos buscando hasta el índice 2
            if (!existingIndices.contains(i)) {
                Log.d("Indices", "Índice faltante encontrado: " + i);
                return i; // Retornar el índice faltante
            }
        }

        Log.d("Indices", "No falta ningún índice.");
        return -1; // Si no falta ningún índice
    }

    private int findMissingIndexIneA() {
        // Definir el rango de índices esperados
        Set<Integer> existingIndices = new HashSet<>();

        // Recorrer las rutas de los archivos garantizados
        for (String path : pathsIneAval) {
            String fileName = new File(path).getName();

            // Verificar que el sufijo sea "GA" antes de procesar el índice
            if (fileName.endsWith("CA.jpeg")) {
                int index = Integer.parseInt(fileName.substring(0, 1)); // Obtener el primer carácter (índice)
                existingIndices.add(index);
                Log.d("Archivos", "Archivo encontrado: " + fileName + " con índice: " + index);
            } else {
                Log.d("Archivos", "Archivo ignorado (no es GA): " + fileName);
            }
        }

        // Si no se encontró ningún archivo GC, marcar todos los índices como faltantes
        if (existingIndices.isEmpty()) {
            Log.d("Indices", "No se encontró ningún archivo Ine, se marcan todos los índices como faltantes.");
            return -1; // Retornar un valor especial que indique que todos los índices están faltantes
        }
        // Verificar índices existentes
        Log.d("Indices existentes3", existingIndices.toString());

        // Buscar el primer índice que falta
        for (int i = 0; i <= 1; i++) { // Asumiendo que estamos buscando hasta el índice 2
            if (!existingIndices.contains(i)) {
                Log.d("Indices", "Índice faltante encontrado: " + i);
                return i; // Retornar el índice faltante
            }
        }

        Log.d("Indices", "No falta ningún índice.");
        return -1; // Si no falta ningún índice
    }

    private int findMissingIndexIne() {
        // Definir el rango de índices esperados
        Set<Integer> existingIndices = new HashSet<>();

        // Recorrer las rutas de los archivos garantizados
        for (String path : pathsIneCliente) {
            String fileName = new File(path).getName();

            // Verificar que el sufijo sea "GA" antes de procesar el índice
            if (fileName.endsWith("CC.jpeg")) {
                int index = Integer.parseInt(fileName.substring(0, 1)); // Obtener el primer carácter (índice)
                existingIndices.add(index);
                Log.d("Archivos", "Archivo encontrado: " + fileName + " con índice: " + index);
            } else {
                Log.d("Archivos", "Archivo ignorado (no es GA): " + fileName);
            }
        }

        // Si no se encontró ningún archivo GC, marcar todos los índices como faltantes
        if (existingIndices.isEmpty()) {
            Log.d("Indices", "No se encontró ningún archivo Ine, se marcan todos los índices como faltantes.");
            return -1; // Retornar un valor especial que indique que todos los índices están faltantes
        }
        // Verificar índices existentes
        Log.d("Indices existentes4", existingIndices.toString());

        // Buscar el primer índice que falta
        for (int i = 0; i <= 1; i++) { // Asumiendo que estamos buscando hasta el índice 2
            if (!existingIndices.contains(i)) {
                Log.d("Indices", "Índice faltante encontrado: " + i);
                return i; // Retornar el índice faltante
            }
        }

        Log.d("Indices", "No falta ningún índice.");
        return -1; // Si no falta ningún índice
    }

    private int findMissingIndexContrato() {
        Set<Integer> existingIndices = new HashSet<>();

        for (String path : pathsContratoCliente) {
            String fileName = new File(path).getName();

            // Verificar si el archivo termina con "CC.jpeg"
            if (fileName.endsWith("CC.jpeg")) {
                try {
                    // Extraer el primer carácter como un número
                    int index = Integer.parseInt(fileName.substring(0, 1));
                    existingIndices.add(index);
                    Log.d("Archivos", "Archivo encontrado: " + fileName + " con índice: " + index);
                } catch (NumberFormatException e) {
                    Log.e("Error", "No se pudo extraer el índice del archivo: " + fileName);
                }
            } else {
                Log.d("Archivos", "Archivo ignorado (no es CC): " + fileName);
            }
        }

        // Si no se encontró ningún archivo GC, marcar todos los índices como faltantes
        if (existingIndices.isEmpty()) {
            Log.d("Indices", "No se encontró ningún archivo Ine, se marcan todos los índices como faltantes.");
            return -1; // Retornar un valor especial que indique que todos los índices están faltantes
        }
        // Verificar índices existentes
        Log.d("Indices existentes5", existingIndices.toString());

        // Buscar el primer índice que falta entre 3 y 4
        for (int i = 3; i <= 4; i++) {
            if (!existingIndices.contains(i)) {
                Log.d("Indices", "Índice faltante encontrado: " + i);
                return i;
            }
        }

        Log.d("Indices", "No falta ningún índice.");
        return -1; // Si no falta ningún índice
    }

    // Método para mostrar la imagen correspondiente en la interfaz
    private void displayImage(Bitmap bitmap, int index) {
        if (index == 0) {
            imgGarantia1.setImageBitmap(bitmap);
            imgGarantia1.setVisibility(View.VISIBLE);
        } else if (index == 1) {
            imgGarantia2.setImageBitmap(bitmap);
            imgGarantia2.setVisibility(View.VISIBLE);
        } else if (index == 2) {
            imgGarantia3.setImageBitmap(bitmap);
            imgGarantia3.setVisibility(View.VISIBLE);
        } else if (index == 3) {
            imgGarantia4.setImageBitmap(bitmap);
            imgGarantia4.setVisibility(View.VISIBLE);
        }
    }

    // Método para mostrar la imagen correspondiente en la interfaz
    private void displayImageGA(Bitmap bitmap, int index) {
        if (index == 0) {
            imgGarantia1A.setImageBitmap(bitmap);
            imgGarantia1A.setVisibility(View.VISIBLE);
        } else if (index == 1) {
            imgGarantia2A.setImageBitmap(bitmap);
            imgGarantia2A.setVisibility(View.VISIBLE);
        } else if (index == 2) {
            imgGarantia3A.setImageBitmap(bitmap);
            imgGarantia3A.setVisibility(View.VISIBLE);
        } else if (index == 3) {
            imgGarantia4A.setImageBitmap(bitmap);
            imgGarantia4A.setVisibility(View.VISIBLE);
        }
    }

    public void subirGarantiasRetiradas() {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);

        editCords(false);

        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), "subirFotosGarantiasRetiradas");
        RequestBody cliente_id = RequestBody.create(MediaType.parse("multipart/form-data"), cliente.getId());
        RequestBody empleado_id = RequestBody.create(MediaType.parse("multipart/form-data"), sesion.getString("id", "0"));
        RequestBody garantias_retiradas_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasRetiradas.size() + "");
        RequestBody fecha_pago = RequestBody.create(MediaType.parse("multipart/form-data"), dateEdt.getText().toString());
        String descripcionText = etDescGarantia.getText().toString();
        RequestBody descripcion = RequestBody.create(MediaType.parse("multipart/form-data"), descripcionText);
        Log.d("DEBUG", "La lista pathsGarantiasRetiradas FORM OK: " + descripcionText );
        Call<ResponseMe> call = retrofitInterface.subirFotosGarantiasRetiradas(archivosGeneral, func,
                cliente_id,
                garantias_retiradas_cliente,
                fecha_pago,
                empleado_id,
                descripcion);
        call.enqueue(new Callback<ResponseMe>() {
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {

                dialog.cancel();
                if (response.isSuccessful()) {

                    Log.d("response", response.body().getMessage());

                    Toast.makeText(getActivity(), "Se han subido las imágenes de las garantías", Toast.LENGTH_LONG).show();

                    dialog.cancel();
                    /*Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard)
                            .navigate(R.id.nav_clientes);*/
                } else {
                    try {

                        JSONObject jObjError = new JSONObject(response.errorBody().string());

                        new MaterialAlertDialogBuilder(getActivity())
                                .setTitle("Aviso")
                                .setMessage(jObjError.getString("message"))
                                .setPositiveButton("Ok", (dialogInterface, i) -> {
                                })
                                .show();

                    } catch (Exception e) {
                        Toast.makeText(getContext(), e.getMessage(), Toast.LENGTH_LONG).show();
                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d("TAG", "onFailure: " + t.getLocalizedMessage());
            }
        });
    }

    @SuppressLint("MissingPermission")
    private void getCurrentLocation(String rol) {
        LocationManager locationManager = (LocationManager)getActivity().getSystemService(Context.LOCATION_SERVICE);

        if (locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER) || locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
            client.getLastLocation().addOnCompleteListener(
                    new OnCompleteListener<Location>() {
                        @Override
                        public void onComplete(@NonNull Task<Location> task) {
                            Location location = task.getResult();

                            if (location != null) {
                                if (Objects.equals(rol, "cliente")) {
                                    lat = String.valueOf(location.getLatitude());
                                    lgt = String.valueOf(location.getLongitude());
                                } else if (Objects.equals(rol, "aval")) {
                                    latAval = String.valueOf(location.getLatitude());
                                    lgtAval = String.valueOf(location.getLongitude());
                                }
                            } else {
                                // When location result is null
                                // initialize location request
                                LocationRequest locationRequest = new LocationRequest()
                                        .setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY)
                                        .setInterval(10000)
                                        .setFastestInterval(1000)
                                        .setNumUpdates(1);

                                LocationCallback locationCallback = new LocationCallback() {
                                    @Override
                                    public void
                                    onLocationResult(
                                            LocationResult
                                                    locationResult)
                                    {
                                        Location location1 = locationResult.getLastLocation();

                                        if (Objects.equals(rol, "cliente")) {
                                            lat = String.valueOf(location.getLatitude());
                                            lgt = String.valueOf(location.getLongitude());
                                        } else if (Objects.equals(rol, "aval")) {
                                            latAval = String.valueOf(location.getLatitude());
                                            lgtAval = String.valueOf(location.getLongitude());
                                        }
                                    }
                                };

                                client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                            }
                        }
                    });
        } else {
            startActivity(new Intent(
                    Settings.ACTION_LOCATION_SOURCE_SETTINGS)
                    .setFlags(Intent.FLAG_ACTIVITY_NEW_TASK));
        }
    }

    public void editCords(Boolean b) {
        JSONObject data = new JSONObject();

        try {
            data.put("func", "editCoords");
            data.put("id", cliente.getAval_id());
            data.put("latitud", latAval);
            data.put("longitud", lgtAval);
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }

        vs = VolleyS.getInstance(this.getContext());
        requestQueue = vs.getRequestQueue();

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlAvales, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        Log.d("resssssAval", String.valueOf(response));
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {

                    }
                });


        JSONObject data2 = new JSONObject();

        try {
            data2.put("func", "actualizarCoordenadasCliente");
            data2.put("id", cliente.getId());
            data2.put("latitud", lat);
            data2.put("longitud", lgt);
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }

        Log.d("7", "loadAllData: ");

        JsonObjectRequest request2 = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data2,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        Log.d("resssssCliente", String.valueOf(response));
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {

                    }
                });

        if (!Objects.equals(lat, "") && !Objects.equals(lgt, "") && Objects.equals(latAval, "") && Objects.equals(lgtAval, "")) {
            requestQueue.add(request2);
        } else if (!Objects.equals(latAval, "") && !Objects.equals(lgtAval, "") && Objects.equals(lat, "") && Objects.equals(lgt, "")) {
            requestQueue.add(request);
        } else {
            requestQueue.add(request2);
            requestQueue.add(request);
        }

    }

    public void subirFotos() {

        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);

        pathsComprobantesCliente.addAll(pathsIneCliente2);
        pathsComprobantesCliente.addAll(pathsContratoCliente2);
        pathsComprobantesCliente.addAll(pathsFotoCliente2);
        pathsComprobantesCliente.addAll(pathsFachadaCliente2);
        pathsComprobantesCliente.addAll(pathsComprobantesCliente2);

        pathsGarantiasCliente.addAll(pathsGarantiasCliente2);

        HashSet<String> set = new HashSet<>(pathsComprobantesCliente);
        pathsComprobantesCliente.clear();
        pathsComprobantesCliente.addAll(set);

        HashSet<String> set2 = new HashSet<>(pathsGarantiasCliente);
        pathsGarantiasCliente.clear();
        pathsGarantiasCliente.addAll(set2);

        //PATHS DE FOTOS DE AVAL
        pathsComprobantesAval.addAll(pathsIneAval2);
        pathsComprobantesAval.addAll(pathsFotoAval2);
        pathsComprobantesAval.addAll(pathsFachadaAval2);
        pathsComprobantesAval.addAll(pathsComprobantesAval2);

        pathsGarantiasAval.addAll(pathsGarantiasAval2);

        HashSet<String> setAval = new HashSet<>(pathsComprobantesAval);
        pathsComprobantesAval.clear();
        pathsComprobantesAval.addAll(setAval);

        HashSet<String> set2Aval = new HashSet<>(pathsGarantiasAval);
        pathsGarantiasAval.clear();
        pathsGarantiasAval.addAll(set2Aval);

        editCords(true);

        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), "subirFotosCYA");
        RequestBody cliente_id = RequestBody.create(MediaType.parse("multipart/form-data"), cliente.getId());
        RequestBody aval_id = RequestBody.create(MediaType.parse("multipart/form-data"), avalId);

        RequestBody cantidad_archivos_garantias_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasCliente.size() + "");
        RequestBody cantidad_archivos_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), pathsComprobantesCliente.size() + "");

        RequestBody cantidad_archivos_garantias_aval = RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasAval.size() + "");
        RequestBody cantidad_archivos_aval = RequestBody.create(MediaType.parse("multipart/form-data"), pathsComprobantesAval.size() + "");

        Log.d("ARCHIVOS3", cliente.getId() + "CLIENTE ID A SUBIR FOTO...................." + cliente.getId());
        Log.d("ARCHIVOS3", "avalId ID A SUBIR FOTO pathsGarantiasCliente...................." + pathsGarantiasCliente.size());
        Log.d("ARCHIVOS3", "avalId ID A SUBIR FOTO pathsComprobantesCliente...................." + pathsComprobantesCliente.size());

        Log.d("ARCHIVOS3", "avalId ID A SUBIR FOTO...................." + avalId);

        Log.d("ARCHIVOS3", "avalId ID A SUBIR FOTO pathsGarantiasAval...................." + pathsGarantiasAval.size());
        Log.d("ARCHIVOS3", "avalId ID A SUBIR FOTO pathsComprobantesAval...................." + pathsComprobantesAval.size());

        Call<ResponseMe> call = retrofitInterface.subirFotosCYA(archivosGeneral, func,
                cliente_id,
                cantidad_archivos_garantias_cliente, cantidad_archivos_cliente, aval_id, cantidad_archivos_garantias_aval, cantidad_archivos_aval);

        call.enqueue(new Callback<ResponseMe>() {
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {

                dialog.cancel();
                if (response.isSuccessful()) {

                    Log.d("response", response.body().getMessage());

                    pathsIneCliente2.clear();
                    pathsContratoCliente2.clear();
                    pathsFotoCliente2.clear();
                    pathsFachadaCliente2.clear();

                    pathsGarantiasCliente2.clear();
                    pathsComprobantesCliente2.clear();

                    pathsFotoAval2.clear();
                    pathsComprobantesAval2.clear();
                    pathsFachadaAval2.clear();
                    pathsIneAval2.clear();

                    pathsComprobantesAval.clear();
                    pathsGarantiasAval.clear();
                    //Toast.makeText(getActivity(), "Se han subido las imagenes del cliente y su aval", Toast.LENGTH_LONG).show();

                    // Crear un MaterialAlertDialog personalizado
                    LayoutInflater inflater = getLayoutInflater();
                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                    // Encuentra el TextView y asigna el texto dinámico
                    TextView messageText = dialogView.findViewById(R.id.message_text);
                    messageText.setText("Se ingresaron los datos correctamente."); // Texto dinámico

                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getActivity());
                    builder.setView(dialogView); // Usa el layout personalizado

                    AlertDialog confirmationDialog = builder.create();
                    confirmationDialog.show();

                    // Cerrar automáticamente el diálogo después de 3 segundos
                    new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);

                    dialog.cancel();

                    fileIndex = 0;


                    lat = "";
                    lgt = "";
                } else {
                    try {
                        JSONObject jObjError = new JSONObject(response.errorBody().string());

                        new MaterialAlertDialogBuilder(getActivity())
                                .setTitle("Aviso")
                                .setMessage(jObjError.getString("message"))
                                .setPositiveButton("Ok", (dialogInterface, i) -> {
                                })
                                .show();
                    } catch (Exception e) {
                        Toast.makeText(getContext(), e.getMessage(), Toast.LENGTH_LONG).show();
                        Log.e("ERROR", "Mensaje de error: " + e.getMessage());

                    }
                }
            }
            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d("TAG", "onFailure: " + t.getLocalizedMessage());
                if (t instanceof IOException) {
                    // Asegúrate de que estas listas estén correctamente pobladas
                    String cantidadGarantias = String.valueOf(pathsGarantiasCliente.size());
                    String cantidadArchivos = String.valueOf(pathsComprobantesCliente.size());

                    // Agregar la solicitud a la cola
                    SolicitudSubida solicitud = new SolicitudSubida(archivosGeneral, "subirFotosCA", cliente.getId(), cantidadGarantias, cantidadArchivos, "cliente");
                    colaSolicitudes.agregarSolicitud(solicitud);

                    String cantidadGarantiasA = String.valueOf(pathsGarantiasAval.size());
                    String cantidadArchivosA = String.valueOf(pathsComprobantesAval.size());

                    // Agregar la solicitud a la cola
                    SolicitudSubida solicitud2 = new SolicitudSubida(archivosGeneral, "subirFotosA", avalId, cantidadGarantiasA, cantidadArchivosA, "aval");
                    colaSolicitudes.agregarSolicitud(solicitud2);

                    // Crear un MaterialAlertDialog personalizado
                    LayoutInflater inflater = getLayoutInflater();
                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                    // Encuentra el TextView y asigna el texto dinámico
                    TextView messageText = dialogView.findViewById(R.id.message_text);
                    messageText.setText("Se perdio la conexión, se guardaron los datos en local."); // Texto dinámico

                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getActivity());
                    builder.setView(dialogView); // Usa el layout personalizado

                    AlertDialog confirmationDialog = builder.create();
                    confirmationDialog.show();

                    // Cerrar automáticamente el diálogo después de 3 segundos
                    new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                }
            }
        });
    }
}